"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _themes = require("../../themes");
var _generateCssVariables = _interopRequireDefault(require("../generate-css-variables.util"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/**
 *
 * Converts theme properties to css variables form and set them locally for
 * given scope
 *
 */

const CarbonScopedTokensProvider = _styledComponents.default.div`
  margin: 0;
  padding: 0;
  width: auto;
  display: inline;

  ${({
  theme
}) => (0, _generateCssVariables.default)(theme.compatibility, theme.roundedCornersOptOut)}
`;
CarbonScopedTokensProvider.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = CarbonScopedTokensProvider;