"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useMediaQuery;
var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function useMediaQuery(queryInput) {
  const query = queryInput.replace(/^@media( ?)/m, "");
  const [match, setMatch] = _react.default.useState(() => false);
  _react.default.useEffect(() => {
    const queryList = window.matchMedia(query);
    const updateMatch = () => {
      setMatch(queryList.matches);
    };
    updateMatch();
    queryList.addEventListener("change", updateMatch);
    return () => {
      queryList.removeEventListener("change", updateMatch);
    };
  }, [query]);
  return match;
}