"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _throttle = _interopRequireDefault(require("lodash/throttle"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
// eslint-disable-next-line @typescript-eslint/no-explicit-any

const useThrottle = (callback, delay) => {
  const callbackRef = (0, _react.useRef)(callback);
  (0, _react.useEffect)(() => {
    callbackRef.current = callback;
  });
  const throttledCallback = (0, _react.useMemo)(() => (0, _throttle.default)(callbackRef.current, delay), [delay]);
  (0, _react.useEffect)(() => {
    return () => {
      throttledCallback.cancel();
    };
  });
  return throttledCallback;
};
var _default = exports.default = useThrottle;