"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
exports.useStableCallback = useStableCallback;
var _react = require("react");
// This is a hook that returns a memoized callback that is guaranteed to be the same reference between renders.
// This is useful when a stable reference is required to prevent unnecessary re-renders.

function useStableCallback(callback) {
  const ref = (0, _react.useRef)(callback);
  ref.current = callback;
  const stableCallback = (0, _react.useCallback)((...args) => ref.current?.(...args), []);
  return callback ? stableCallback : undefined;
}
var _default = exports.default = useStableCallback;