"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useResizeObserver;
var _react = require("react");
function useResizeObserver( /** Reference to the resizable HTML element */
ref, /** Callback meant to be executed on element resize */
onResize, /** Flag to indicate whether hook should be disabled  */
disabled) {
  const observer = (0, _react.useRef)();
  const onResizeRef = (0, _react.useRef)(onResize);
  onResizeRef.current = onResize;
  (0, _react.useLayoutEffect)(() => {
    const referenceRef = ref.current;
    if (!disabled && referenceRef) {
      observer.current = new ResizeObserver(() => {
        onResizeRef?.current();
      });
      observer.current.observe(referenceRef);
    }
    return () => {
      if (!disabled && referenceRef && observer.current) {
        observer.current.unobserve(referenceRef);
        observer.current.disconnect();
      }
    };
  }, [ref, disabled]);
}