"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _modalManager = _interopRequireDefault(require("../../../components/modal/__internal__/modal-manager"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const useModalManager = ({
  open,
  closeModal,
  modalRef,
  setTriggerRefocusFlag,
  triggerRefocusOnClose = true,
  topModalOverride = false
}) => {
  const listenerAdded = (0, _react.useRef)(false);
  const modalRegistered = (0, _react.useRef)(false);
  const handleClose = (0, _react.useCallback)(ev => {
    const isTopmost = _modalManager.default.isTopmost(modalRef.current);
    if (isTopmost) {
      closeModal(ev);
    }
  }, [modalRef, closeModal]);
  const addListener = (0, _react.useCallback)(() => {
    /* istanbul ignore else */
    if (!listenerAdded.current) {
      document.addEventListener("keyup", handleClose);
      listenerAdded.current = true;
    }
  }, [handleClose]);
  const removeListener = (0, _react.useCallback)(() => {
    if (listenerAdded.current) {
      document.removeEventListener("keyup", handleClose);
      listenerAdded.current = false;
    }
  }, [handleClose]);
  (0, _react.useEffect)(() => {
    if (open) {
      addListener();
    } else {
      removeListener();
    }
  }, [addListener, open, removeListener]);
  (0, _react.useEffect)(() => {
    return () => {
      removeListener();
    };
  }, [removeListener]);
  const registerModal = (0, _react.useCallback)(ref => {
    /* istanbul ignore else */
    if (!modalRegistered.current) {
      _modalManager.default.addModal(ref, setTriggerRefocusFlag, topModalOverride);
      modalRegistered.current = true;
    }
  }, [setTriggerRefocusFlag, topModalOverride]);
  const unregisterModal = (0, _react.useCallback)(ref => {
    if (modalRegistered.current) {
      _modalManager.default.removeModal(ref, triggerRefocusOnClose);
      modalRegistered.current = false;
    }
  }, [triggerRefocusOnClose]);
  (0, _react.useEffect)(() => {
    const ref = modalRef.current;
    if (open) {
      registerModal(ref);
    } else {
      unregisterModal(ref);
    }
  }, [modalRef, open, registerModal, unregisterModal]);
  (0, _react.useEffect)(() => {
    const ref = modalRef.current;
    return () => {
      unregisterModal(ref);
    };
  }, [modalRef, unregisterModal]);
};
var _default = exports.default = useModalManager;