"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _focusTrapUtils = require("../../../__internal__/focus-trap/focus-trap-utils");
var _useModalManager = _interopRequireDefault(require("../useModalManager"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var _default = (mainControlRef, getButtonChildren, hide, isOpen) => {
  const refocusMainControl = (0, _react.useCallback)(() => {
    hide();
    mainControlRef.current?.focus();
  }, [hide, mainControlRef]);
  const handleEscapeKey = (0, _react.useCallback)(e => {
    /* istanbul ignore else */
    if (_events.default.isEscKey(e)) {
      refocusMainControl();
    }
  }, [refocusMainControl]);

  // useModalmanager is used here to handle the escape key
  // and to ensure that closing the menu does not close the modal
  (0, _useModalManager.default)({
    open: isOpen,
    closeModal: handleEscapeKey,
    modalRef: mainControlRef
  });
  const handleKeyDown = (0, _react.useCallback)(ev => {
    if (!(_events.default.isEnterKey(ev) || _events.default.isSpaceKey(ev))) {
      ev.preventDefault();
    }
    const buttonChildren = getButtonChildren();
    const childrenLength = buttonChildren?.length;
    let nextIndex = -1;
    const currentIndex = Array.from(buttonChildren).indexOf(document.activeElement);
    const arrowModifierPressed = ev.ctrlKey || ev.metaKey;
    if (_events.default.isEndKey(ev) || arrowModifierPressed && _events.default.isDownKey(ev)) {
      nextIndex = childrenLength - 1;
    }
    if (_events.default.isHomeKey(ev) || arrowModifierPressed && _events.default.isUpKey(ev)) {
      nextIndex = 0;
    }
    if (!arrowModifierPressed && _events.default.isUpKey(ev) && currentIndex > 0) {
      nextIndex = currentIndex - 1;
    }
    if (!arrowModifierPressed && _events.default.isDownKey(ev) && currentIndex < childrenLength - 1) {
      nextIndex = currentIndex + 1;
    }
    const tabPressed = _events.default.isTabKey(ev);
    const tabShiftPressed = tabPressed && _events.default.isShiftKey(ev);
    if (tabShiftPressed) {
      if (currentIndex === 0) {
        refocusMainControl();
      } else {
        nextIndex = currentIndex - 1;
      }
    } else if (tabPressed) {
      if (currentIndex === childrenLength - 1) {
        const elements = Array.from(document.querySelectorAll(_focusTrapUtils.defaultFocusableSelectors)).filter(el => Number(el.tabIndex) !== -1);
        const indexOf = elements.indexOf(mainControlRef.current);
        elements[indexOf + 1]?.focus();
        // timeout enforces that the "hide" method will be run after browser focuses on the next element
        setTimeout(hide, 0);
      } else {
        nextIndex = currentIndex + 1;
      }
    }
    if (nextIndex > -1) {
      buttonChildren?.[nextIndex]?.focus();
    }
  }, [hide, refocusMainControl, mainControlRef, getButtonChildren]);
  return handleKeyDown;
};
exports.default = _default;