"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useInputAccessibility;
function useInputAccessibility({
  id,
  validationRedesignOptIn,
  error,
  warning,
  info,
  label,
  fieldHelp
}) {
  const labelId = label ? `${id}-label` : undefined;
  const validationId = [error, warning, info].filter(validation => validation && typeof validation === "string").length ? `${id}-validation` : undefined;
  const fieldHelpId = fieldHelp ? `${id}-field-help` : undefined;
  const descriptionList = fieldHelpId ? [fieldHelpId] : [];
  if (validationRedesignOptIn && validationId) {
    descriptionList.push(validationId);
  }
  const ariaDescribedBy = descriptionList.length ? descriptionList.filter(Boolean).join(" ") : undefined;
  return {
    labelId,
    validationId,
    fieldHelpId,
    ariaDescribedBy
  };
}