"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _focusTrapUtils = require("../../../__internal__/focus-trap/focus-trap-utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
var _default = (container, target, focusCallback) => {
  (0, _react.useEffect)(() => {
    const handleFocusPortalContent = ev => {
      if (container?.current && target?.current) {
        const focusableElementsInContainer = Array.from(container.current?.querySelectorAll(_focusTrapUtils.defaultFocusableSelectors) || /* istanbul ignore next */[]);
        if (target?.current === document.activeElement) {
          if (_events.default.isTabKey(ev) && !_events.default.isShiftKey(ev) && focusableElementsInContainer[0]) {
            ev.preventDefault();
            focusableElementsInContainer[0]?.focus();
          }
          return;
        }

        /* istanbul ignore if */
        if (!focusableElementsInContainer.length) {
          return;
        }
        const lastElementFocused = focusableElementsInContainer[focusableElementsInContainer.length - 1] === document.activeElement;
        const firstElementFocused = focusableElementsInContainer[0] === document.activeElement;
        if (_events.default.isTabKey(ev)) {
          // last element focused inside portal navigate to next element in DOM after the target/ trigger element
          if (lastElementFocused && !_events.default.isShiftKey(ev)) {
            ev.preventDefault();
            const allFocusableElements = Array.from(document.querySelectorAll(_focusTrapUtils.defaultFocusableSelectors) || /* istanbul ignore next */[]);
            const filteredElements = allFocusableElements.filter(el => el === target.current || Number(el.tabIndex) !== -1);
            const nextIndex = filteredElements.indexOf(target.current) + 1;
            focusCallback?.(ev);
            filteredElements[nextIndex]?.focus();
            return;
          }
          // first element focused inside portal navigate back to the target/ trigger element
          if (firstElementFocused && _events.default.isShiftKey(ev)) {
            ev.preventDefault();
            focusCallback?.(ev);

            /* istanbul ignore else */
            if (target.current !== document.activeElement) {
              target.current?.focus();
            }
          }
        }
      }
    };
    document.addEventListener("keydown", handleFocusPortalContent);
    return () => {
      document.removeEventListener("keydown", handleFocusPortalContent);
    };
  }, [target, container, focusCallback]);
};
exports.default = _default;