"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _dom = require("@floating-ui/dom");
const useFloating = ({
  isOpen,
  reference,
  floating,
  strategy = "absolute",
  placement,
  middleware,
  animationFrame
}) => {
  const originalValues = (0, _react.useRef)(null);
  (0, _react.useLayoutEffect)(() => {
    let cleanup;
    const referenceElement = reference.current;
    const floatingElement = floating.current;
    if (referenceElement && floatingElement && isOpen) {
      const {
        left,
        top,
        position,
        width,
        height
      } = floatingElement.style;
      originalValues.current = {
        left,
        top,
        position,
        width,
        height
      };
      Object.assign(floatingElement.style, {
        position: strategy,
        top: 0,
        left: 0
      });
      const update = () => {
        (0, _dom.computePosition)(referenceElement, floatingElement, {
          strategy,
          middleware,
          placement
        }).then(({
          x,
          y,
          placement: currentPlacement
        }) => {
          Object.assign(floatingElement.style, {
            left: `${x}px`,
            top: `${y}px`,
            position: strategy
          });
          floatingElement.setAttribute("data-floating-placement", currentPlacement);
        });
      };
      cleanup = (0, _dom.autoUpdate)(referenceElement, floatingElement, update, {
        animationFrame
      });
    }
    return () => {
      if (cleanup && floatingElement) {
        cleanup();
        cleanup = null;
        Object.assign(floatingElement.style, originalValues.current);
        floatingElement.removeAttribute("data-floating-placement");
      }
    };
  }, [isOpen, reference, floating, strategy, middleware, placement, animationFrame]);
};
var _default = exports.default = useFloating;