"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _debounce = _interopRequireDefault(require("lodash/debounce"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
// eslint-disable-next-line @typescript-eslint/no-explicit-any

const useDebounce = (callback, delay) => {
  const callbackRef = (0, _react.useRef)(callback);
  (0, _react.useEffect)(() => {
    callbackRef.current = callback;
  });
  const debouncedCallback = (0, _react.useMemo)(() => (0, _debounce.default)(callbackRef.current, delay), [delay]);
  (0, _react.useEffect)(() => {
    return () => {
      debouncedCallback.cancel();
    };
  });
  return debouncedCallback;
};
var _default = exports.default = useDebounce;