"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
// Needs to also take Portals into account (so can't just check DOM containment), but ideally without using
// event.stopPropagation() which could have unexpected and frustrating consequences for consumers.
// Simple approach taken from https://github.com/facebook/react/issues/10962#issuecomment-444622208
var _default = (handleClickAway, eventTypeId = "click") => {
  const clickIsInside = (0, _react.useRef)(false);
  const onDocumentClick = (0, _react.useCallback)(ev => {
    if (clickIsInside.current) {
      clickIsInside.current = false;
      return;
    }
    handleClickAway(ev);
  }, [handleClickAway]);
  const onInsideClick = (0, _react.useCallback)(() => {
    clickIsInside.current = true;
  }, []);
  (0, _react.useEffect)(() => {
    document.addEventListener(eventTypeId, onDocumentClick);
    return function cleanup() {
      document.removeEventListener(eventTypeId, onDocumentClick);
    };
  }, [onDocumentClick, eventTypeId]);
  return onInsideClick;
};
exports.default = _default;