"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("react");
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events"));
var _useMenuKeyboardNavigation = _interopRequireDefault(require("../useMenuKeyboardNavigation"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const useChildButtons = (toggleButtonRef, widthRatio = 1) => {
  const [showAdditionalButtons, setShowAdditionalButtons] = (0, _react.useState)(false);
  const [minWidth, setMinWidth] = (0, _react.useState)(0);
  const buttonNode = (0, _react.useRef)(null);
  const childrenContainer = (0, _react.useRef)(null);
  const focusFirstChildButtonOnOpen = (0, _react.useRef)(false);
  const hideButtons = (0, _react.useCallback)(() => {
    setShowAdditionalButtons(false);
  }, []);
  function showButtons() {
    setShowAdditionalButtons(true);

    /* istanbul ignore else */
    if (buttonNode.current) {
      setMinWidth(widthRatio * buttonNode.current.getBoundingClientRect().width);
    }
  }
  const getButtonChildren = (0, _react.useCallback)(() => childrenContainer.current?.querySelectorAll('[data-component="button"]'), []);
  (0, _react.useEffect)(() => {
    const firstChild = getButtonChildren()?.[0];
    if (focusFirstChildButtonOnOpen.current && showAdditionalButtons && firstChild) {
      focusFirstChildButtonOnOpen.current = false;
      firstChild.focus();
    }
  }, [showAdditionalButtons, getButtonChildren]);
  const handleToggleButtonKeyDown = ev => {
    if (_events.default.isEnterKey(ev) || _events.default.isSpaceKey(ev) || _events.default.isDownKey(ev) || _events.default.isUpKey(ev)) {
      ev.preventDefault();
      if (!showAdditionalButtons) {
        showButtons();
      }
      focusFirstChildButtonOnOpen.current = true;
    }
  };
  const handleKeyDown = (0, _useMenuKeyboardNavigation.default)(toggleButtonRef, getButtonChildren, hideButtons, showAdditionalButtons);
  const onChildButtonClick = childOnClick => ev => {
    childOnClick?.(ev);
    hideButtons();
    toggleButtonRef.current?.focus();
  };
  const wrapperProps = {
    "data-element": "additional-buttons",
    role: "list",
    onKeyDown: handleKeyDown,
    minWidth,
    ref: childrenContainer
  };
  const contextValue = {
    inSplitButton: true,
    onChildButtonClick
  };
  return {
    showAdditionalButtons,
    showButtons,
    hideButtons,
    buttonNode,
    handleToggleButtonKeyDown,
    wrapperProps,
    contextValue
  };
};
var _default = exports.default = useChildButtons;