"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _characterCount = _interopRequireDefault(require("../../../__internal__/character-count"));
var _guid = _interopRequireDefault(require("../../../__internal__/utils/helpers/guid"));
var _useDebounce = _interopRequireDefault(require("../useDebounce"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useCharacterCount = (value = "", characterLimit) => {
  const isCharacterLimitValid = typeof characterLimit === "number" && !Number.isNaN(characterLimit);
  const [debouncedValue, setDebouncedValue] = (0, _react.useState)(value);
  const debounceWaitTime = 2000;
  const updateDebouncedValue = (0, _useDebounce.default)(newValue => {
    setDebouncedValue(newValue);
  }, debounceWaitTime);
  (0, _react.useEffect)(() => {
    if (characterLimit) {
      updateDebouncedValue(value);
    }
  }, [value, characterLimit, updateDebouncedValue]);
  const hintId = (0, _react.useRef)((0, _guid.default)());
  const isOverLimit = (0, _react.useMemo)(() => {
    if (value && isCharacterLimitValid) {
      return value.length > characterLimit;
    }
    return false;
  }, [value, characterLimit, isCharacterLimitValid]);
  const isDebouncedOverLimit = (0, _react.useMemo)(() => {
    if (debouncedValue && isCharacterLimitValid) {
      return debouncedValue.length > characterLimit;
    }
    return false;
  }, [debouncedValue, characterLimit, isCharacterLimitValid]);
  return [isCharacterLimitValid ? /*#__PURE__*/_react.default.createElement(_characterCount.default, {
    isOverLimit: isOverLimit,
    isDebouncedOverLimit: isDebouncedOverLimit,
    value: value.length,
    debouncedValue: debouncedValue.length,
    limit: characterLimit,
    visuallyHiddenHintId: hintId.current
  }) : null, isCharacterLimitValid ? hintId.current : undefined];
};
var _default = exports.default = useCharacterCount;