"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledVerticalMenuItem = exports.StyledVerticalMenuFullScreen = exports.StyledVerticalMenu = exports.StyledTitleIcon = exports.StyledTitle = exports.StyledList = exports.StyledChevronIcon = exports.StyledAdornment = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _icon2 = _interopRequireDefault(require("../icon"));
var _box = _interopRequireDefault(require("../box/box.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledList = exports.StyledList = _styledComponents.default.ul`
  list-style: none;
  margin: 0;
  padding: 0;
`;
const oldFocusStyling = `
  outline: 3px solid var(--colorsSemanticFocus500);
  outline-offset: -3px;
`;
const StyledVerticalMenuItem = exports.StyledVerticalMenuItem = _styledComponents.default.div`
  min-height: ${({
  height
}) => height};
  width: 100%;
  display: flex;
  border: none;
  align-items: center;
  font-weight: 600;
  font-size: 14px;
  cursor: pointer;
  color: var(--colorsComponentsLeftnavWinterStandardContent);
  position: relative;
  box-sizing: border-box;
  text-decoration: none;
  background-color: var(--colorsComponentsLeftnavWinterStandardBackground);

  ${_styledSystem.padding}

  &:hover {
    background-color: var(--colorsComponentsLeftnavWinterStandardHover);
  }

  &:focus {
    ${({
  theme
}) => !theme.focusRedesignOptOut ? (0, _addFocusStyling.default)(true) : /* istanbul ignore next */oldFocusStyling}
  }

  ${({
  active
}) => active && (0, _styledComponents.css)`
      &:before {
        background: var(--colorsComponentsLeftnavWinterStandardSelected);
        border-radius: var(--borderRadius100);
        content: "";
        height: calc(100% - 16px);
        left: 24px;
        position: absolute;
        top: 8px;
        width: calc(100% - 48px);
        z-index: 0;
      }

      &:hover {
        &:before {
          background: var(--colorsComponentsLeftnavWinterStandardHover);
        }
      }
    `}

  ${_icon.default} {
    width: 20px;
  }
`;
StyledVerticalMenuItem.defaultProps = {
  theme: _base.default
};
const StyledTitle = exports.StyledTitle = _styledComponents.default.h3`
  font-weight: 600;
  font-size: 14px;
  line-height: 21px;
  margin: 0;
  z-index: 1;
  text-align: left;
`;
const StyledAdornment = exports.StyledAdornment = _styledComponents.default.div`
  display: flex;
  align-items: center;
  justify-content: flex-end;
  flex: 1;
`;
const StyledTitleIcon = exports.StyledTitleIcon = (0, _styledComponents.default)(_icon2.default)`
  margin-right: 12px;
  width: 20px;
  color: var(--colorsComponentsLeftnavWinterStandardContent);
`;
const StyledChevronIcon = exports.StyledChevronIcon = (0, _styledComponents.default)(_icon2.default)`
  margin-left: auto;
  padding-left: 12px;
  width: 20px;
  color: var(--colorsComponentsLeftnavWinterStandardContent);
`;
const StyledVerticalMenu = exports.StyledVerticalMenu = (0, _styledComponents.default)(_box.default)`
  // TODO remove hardcoded values when DS have had chance to review which token to use
  &::-webkit-scrollbar-track {
    background-color: #cccccc;
  }
  &::-webkit-scrollbar-thumb {
    background-color: #808080;
  }
  &::-webkit-scrollbar {
    width: 12px;
  }
`;
const StyledVerticalMenuFullScreen = exports.StyledVerticalMenuFullScreen = (0, _styledComponents.default)(_box.default)`
  position: fixed;
  top: 0;
  bottom: 0;
  height: 100vh;
  width: 100%;
  outline: none;
  padding: 8px 0px;
  overflow: auto;
  background-color: var(--colorsComponentsLeftnavWinterStandardBackground);
  box-sizing: border-box;
  transition: all 0.3s ease;
  z-index: ${({
  theme
}) => theme.zIndex.fullScreenModal};

  // TODO remove hardcoded values when DS have had chance to review which token to use
  &::-webkit-scrollbar-track {
    background-color: #cccccc;
  }
  &::-webkit-scrollbar-thumb {
    background-color: #808080;
  }
  &::-webkit-scrollbar {
    width: 12px;
  }
`;