"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.VerticalMenu = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags"));
var _verticalMenu = require("./vertical-menu.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const VerticalMenu = ({
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  width = "322px",
  children,
  height = "100%",
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledVerticalMenu, _extends({
    boxSizing: "border-box",
    scrollVariant: "light",
    backgroundColor: "var(--colorsComponentsLeftnavWinterStandardBackground)",
    width: width,
    height: height,
    py: 1,
    as: "nav",
    overflow: "auto",
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy
  }, (0, _tags.default)("vertical-menu", rest)), /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledList, null, children));
};
exports.VerticalMenu = VerticalMenu;
var _default = exports.default = VerticalMenu;