import React from "react";
import { TagProps } from "../../__internal__/utils/helpers/tags";
export interface VerticalMenuProps extends TagProps {
    /** An aria-label attribute for the menu */
    "aria-label"?: string;
    /** An aria-labelledby attribute for the menu */
    "aria-labelledby"?: string;
    /** Width of the menu */
    width?: string;
    /** Content of the menu - VerticalMenuItem */
    children: React.ReactNode;
    /** Height of the menu */
    height?: string;
}
export declare const VerticalMenu: ({ "aria-label": ariaLabel, "aria-labelledby": ariaLabelledBy, width, children, height, ...rest }: VerticalMenuProps) => React.JSX.Element;
export default VerticalMenu;
