"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.VerticalMenuTrigger = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags"));
var _utils = require("../../../style/utils");
var _verticalMenu = require("../vertical-menu.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const VerticalMenuTrigger = ({
  height = "40px",
  p = 2,
  onClick,
  children,
  ...rest
}) => {
  const paddingProps = (0, _utils.filterStyledSystemPaddingProps)(rest);
  return /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledVerticalMenuItem, _extends({
    onClick: onClick,
    as: "button",
    height: height,
    p: p,
    tabIndex: 0
  }, paddingProps, (0, _tags.default)("vertical-menu-trigger", rest)), /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledTitle, null, children));
};
exports.VerticalMenuTrigger = VerticalMenuTrigger;
var _default = exports.default = VerticalMenuTrigger;