"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.VerticalMenuItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags"));
var _utils = require("../../../style/utils");
var _verticalMenuFullScreen = _interopRequireDefault(require("../vertical-menu-full-screen/vertical-menu-full-screen.context"));
var _verticalMenu = require("../vertical-menu.style");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const MenuItemContext = /*#__PURE__*/_react.default.createContext({
  level: 0
});
const VerticalMenuItem = ({
  defaultOpen = false,
  title,
  iconType,
  adornment,
  children,
  component,
  active,
  height = "56px",
  href,
  ...rest
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(defaultOpen);
  const handleOnClick = () => {
    setIsOpen(state => !state);
  };
  const {
    level
  } = (0, _react.useContext)(MenuItemContext);
  const {
    isFullScreen
  } = (0, _react.useContext)(_verticalMenuFullScreen.default);
  const renderAdornment = () => typeof adornment === "function" ? adornment(isOpen) : adornment;
  const shouldDisplayActiveState = typeof active === "function" ? active(isOpen) : active;
  let itemProps = {};
  if (href) {
    itemProps = {
      as: "a",
      href
    };
  }
  if (component) {
    itemProps = {
      as: component,
      href,
      tabIndex: 0,
      ...rest
    };
  }
  if (children) {
    itemProps = {
      as: "button",
      type: "button",
      "aria-expanded": isOpen,
      onClick: handleOnClick
    };
  }
  const paddingX = `calc(var(--spacing500) + (${level} * var(--spacing400)))`;
  return /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledVerticalMenuItem, _extends({
    height: height,
    px: paddingX,
    py: 2,
    active: shouldDisplayActiveState
  }, itemProps, (0, _utils.filterStyledSystemPaddingProps)(rest), (0, _tags.default)("vertical-menu-item", rest)), iconType && /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledTitleIcon, {
    type: iconType
  }), /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledTitle, null, title), adornment && /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledAdornment, null, renderAdornment()), children && !isFullScreen && /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledChevronIcon, {
    type: isOpen ? "chevron_up_thick" : "chevron_down_thick"
  })), (isOpen || isFullScreen) && /*#__PURE__*/_react.default.createElement(MenuItemContext.Provider, {
    value: {
      level: level + 1
    }
  }, /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledList, null, children)));
};
exports.VerticalMenuItem = VerticalMenuItem;
var _default = exports.default = VerticalMenuItem;