"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.VerticalMenuFullScreen = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags"));
var _useLocale = _interopRequireDefault(require("../../../hooks/__internal__/useLocale"));
var _portal = _interopRequireDefault(require("../../portal"));
var _focusTrap = _interopRequireDefault(require("../../../__internal__/focus-trap/focus-trap.component"));
var _iconButton = _interopRequireDefault(require("../../icon-button"));
var _icon = _interopRequireDefault(require("../../icon"));
var _box = _interopRequireDefault(require("../../box"));
var _verticalMenu = require("../vertical-menu.style");
var _verticalMenuFullScreen = _interopRequireDefault(require("../vertical-menu-full-screen/vertical-menu-full-screen.context"));
var _events = _interopRequireDefault(require("../../../__internal__/utils/helpers/events/events"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const VerticalMenuFullScreen = ({
  "aria-label": ariaLabel,
  "aria-labelledby": ariaLabelledBy,
  children,
  isOpen,
  onClose,
  ...rest
}) => {
  const l = (0, _useLocale.default)();
  const menuWrapperRef = (0, _react.useRef)(null);
  const handleKeyDown = (0, _react.useCallback)(ev => {
    // istanbul ignore else
    if (_events.default.isEscKey(ev)) {
      onClose(ev);
    }
  }, [onClose]);

  // TODO remove this as part of FE-5650
  if (!isOpen) return null;
  return /*#__PURE__*/_react.default.createElement(_portal.default, null, /*#__PURE__*/_react.default.createElement(_focusTrap.default, {
    isOpen: isOpen,
    wrapperRef: menuWrapperRef
  }, /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledVerticalMenuFullScreen, _extends({
    ref: menuWrapperRef,
    scrollVariant: "light",
    as: "nav",
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledBy,
    onKeyDown: handleKeyDown
  }, (0, _tags.default)("vertical-menu-full-screen", rest)), /*#__PURE__*/_react.default.createElement(_box.default, {
    display: "flex",
    justifyContent: "flex-end",
    height: "60px",
    alignItems: "flex-start",
    px: "20px",
    pt: "20px",
    boxSizing: "border-box"
  }, /*#__PURE__*/_react.default.createElement(_iconButton.default, {
    "aria-label": l.verticalMenuFullScreen.ariaLabels.close(),
    onClick: onClose,
    "data-element": "close"
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    type: "close",
    color: "var(--colorsComponentsLeftnavWinterStandardContent)",
    bgSize: "small",
    fontSize: "medium"
  }))), /*#__PURE__*/_react.default.createElement(_verticalMenuFullScreen.default.Provider, {
    value: {
      isFullScreen: true
    }
  }, /*#__PURE__*/_react.default.createElement(_verticalMenu.StyledList, null, children)))));
};
exports.VerticalMenuFullScreen = VerticalMenuFullScreen;
var _default = exports.default = VerticalMenuFullScreen;