"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _color = _interopRequireDefault(require("../../style/utils/color"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _visuallyHidden = _interopRequireDefault(require("../../style/utils/visually-hidden"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getAs = variant => {
  switch (variant) {
    case "h1-large":
      return "h1";
    case "segment-header":
    case "segment-header-small":
    case "segment-subheader":
    case "segment-subheader-alt":
      return "h5";
    case "big":
      return "p";
    default:
      return variant;
  }
};
const getSize = variant => {
  switch (variant) {
    case "h1-large":
      return "32px";
    case "h1":
      return "24px";
    case "h2":
      return "22px";
    case "h3":
    case "segment-header":
      return "20px";
    case "h4":
    case "segment-header-small":
      return "18px";
    case "h5":
    case "segment-subheader":
    case "big":
      return "16px";
    case "small":
    case "sub":
    case "sup":
      return "13px";
    case "segment-subheader-alt":
    case "p":
    case "span":
    case "b":
    case "strong":
    case "em":
    default:
      return "14px";
  }
};
const getLineHeight = variant => {
  switch (variant) {
    case "h1-large":
      return "40px";
    case "h1":
    case "segment-subheader":
      return "31px";
    case "h2":
      return "29px";
    case "h3":
    case "segment-header":
      return "26px";
    case "big":
      return "24px";
    case "h4":
    case "segment-header-small":
      return "23px";
    case "small":
    case "sub":
    case "sup":
      return "20px";
    case "h5":
    case "segment-subheader-alt":
    case "p":
    case "span":
    case "b":
    case "strong":
    case "em":
    default:
      return "21px";
  }
};
const getWeight = variant => {
  switch (variant) {
    case "h1-large":
    case "h1":
    case "segment-header":
    case "segment-header-small":
      return "900";
    case "h2":
    case "h3":
    case "segment-subheader":
    case "segment-subheader-alt":
    case "b":
    case "em":
    case "strong":
      return "700";
    case "h4":
    case "h5":
    case "p":
    case "span":
    case "small":
    case "big":
    case "sub":
    case "sup":
    default:
      return "400";
  }
};
const getTransform = variant => {
  if (variant === "segment-subheader-alt") {
    return "uppercase";
  }
  return "none";
};
const getDecoration = variant => {
  if (variant === "em") {
    return "underline";
  }
  return "none";
};
const StyledTypography = _styledComponents.default.span.attrs(({
  variant,
  as,
  fontSize,
  fontWeight,
  textTransform,
  lineHeight,
  textDecoration
}) => {
  return {
    as: as || getAs(variant),
    size: fontSize || getSize(variant),
    weight: fontWeight || getWeight(variant),
    textTransform: textTransform || getTransform(variant),
    textDecoration: textDecoration || getDecoration(variant),
    lineHeight: lineHeight || getLineHeight(variant),
    defaultMargin: variant === "p" ? "0 0 16px" : "0"
  };
})`
  ${({
  size,
  weight,
  textTransform,
  lineHeight,
  defaultMargin,
  textDecoration,
  display,
  variant,
  listStyleType,
  whiteSpace,
  wordWrap,
  textAlign,
  textOverflow,
  truncate,
  screenReaderOnly
}) => (0, _styledComponents.css)`
    font-style: normal;
    font-size: ${size};
    font-weight: ${weight};
    text-transform: ${textTransform};
    text-decoration: ${textDecoration};
    line-height: ${lineHeight};
    margin: ${defaultMargin};
    padding: 0;
    white-space: ${truncate ? "nowrap" : whiteSpace};
    word-wrap: ${wordWrap};
    text-align: ${textAlign};
    text-overflow: ${textOverflow || truncate && "ellipsis"};
    ${truncate && (0, _styledComponents.css)`
      overflow: hidden;
    `};
    ${screenReaderOnly && _visuallyHidden.default}
    ${variant === "sup" && "vertical-align: super;"};
    ${variant === "sub" && "vertical-align: sub;"};
    ${display && `display: ${display};`};
    ${listStyleType && `list-style-type: ${listStyleType};`}; ;
  `}
  ${_styledSystem.space}
    ${({
  color,
  bg,
  backgroundColor,
  ...rest
}) => (0, _color.default)({
  color,
  bg,
  backgroundColor,
  ...rest
})}
  ${({
  isDisabled
}) => isDisabled && (0, _styledComponents.css)`
      color: var(--colorsUtilityYin030);
    `}
`;
StyledTypography.defaultProps = {
  theme: _base.default
};
StyledTypography.displayName = "Typography";
var _default = exports.default = StyledTypography;