"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.VARIANT_TYPES = exports.Typography = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags"));
var _utils = require("../../style/utils");
var _typography = _interopRequireDefault(require("./typography.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const VARIANT_TYPES = exports.VARIANT_TYPES = ["h1-large", "h1", "h2", "h3", "h4", "h5", "segment-header", "segment-header-small", "segment-subheader", "segment-subheader-alt", "p", "span", "small", "big", "sup", "sub", "strong", "b", "em", "ul", "ol"];
const Typography = ({
  "data-component": dataComponent,
  variant = "p",
  as,
  id,
  fontSize,
  fontWeight,
  textTransform,
  lineHeight,
  textDecoration,
  display,
  listStyleType,
  whiteSpace,
  wordWrap,
  textAlign,
  textOverflow,
  truncate,
  color = "blackOpacity90",
  backgroundColor,
  bg,
  opacity,
  children,
  className,
  screenReaderOnly,
  isDisabled,
  "aria-hidden": ariaHidden,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_typography.default, _extends({
    variant: variant,
    as: as,
    id: id,
    fontSize: fontSize,
    fontWeight: fontWeight,
    textTransform: textTransform,
    lineHeight: lineHeight,
    textDecoration: textDecoration,
    display: display,
    listStyleType: listStyleType,
    whiteSpace: whiteSpace,
    wordWrap: wordWrap,
    textAlign: textAlign,
    textOverflow: textOverflow,
    truncate: truncate,
    color: color,
    backgroundColor: backgroundColor,
    bg: bg,
    opacity: opacity,
    className: className,
    screenReaderOnly: screenReaderOnly,
    isDisabled: isDisabled,
    "aria-hidden": ariaHidden
  }, (0, _tags.default)(dataComponent, rest), (0, _utils.filterStyledSystemMarginProps)(rest), (0, _utils.filterStyledSystemPaddingProps)(rest)), children);
};
exports.Typography = Typography;
Typography.displayName = "Typography";
var _default = exports.default = Typography;