"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListItem = exports.List = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _typography = _interopRequireDefault(require("./typography.component"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const getListStyleType = as => {
  if (as === "ul") {
    return "square";
  }
  return "decimal";
};
const List = ({
  children,
  as = "ul",
  ...props
}) => /*#__PURE__*/_react.default.createElement(_typography.default, _extends({
  variant: "p",
  as: as,
  listStyleType: getListStyleType(as)
}, props), children);
exports.List = List;
const ListItem = ({
  children,
  ...props
}) => /*#__PURE__*/_react.default.createElement(_typography.default, _extends({
  as: "li",
  variant: "p",
  m: "0 0 8px 16px"
}, props), children);
exports.ListItem = ListItem;