"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _color = require("../../style/utils/color");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fadeIn = (0, _styledComponents.keyframes)`
  0% {
    opacity: 0;
  }

  100% {
    opacity: 1;
  }
`;
const tooltipColor = (theme, bgColor, type) => {
  if (bgColor) return (0, _color.toColor)(theme, bgColor);
  return type === "error" ? "var(--colorsSemanticNegative500)" : "var(--colorsSemanticNeutral500)";
};
const StyledTooltip = _styledComponents.default.div`
  ${({
  size,
  theme,
  type,
  bgColor,
  fontColor
}) => (0, _styledComponents.css)`
    bottom: auto;
    right: auto;
    max-width: 300px;
    width: max-content;
    border-radius: var(--borderRadius050);
    position: absolute;
    animation: ${fadeIn} 0.2s linear;
    z-index: ${theme.zIndex.popover}; // TODO (tokens): implement elevation tokens - FE-4437
    text-align: left;
    color: ${fontColor ? (0, _color.toColor)(theme, fontColor) : "var(--colorsSemanticNeutralYang100)"};
    display: inline-block;
    padding: 8px 12px;
    word-break: break-word;
    white-space: pre-wrap;
    font-size: ${size === "medium" ? "14px" : "16px"};
    line-height: 1.5rem;
    font-weight: 400;
    background-color: ${tooltipColor(theme, bgColor, type)};
  `}
`;
StyledTooltip.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledTooltip;