"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Tooltip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _invariant = _interopRequireDefault(require("invariant"));
var _reactDom = require("@floating-ui/react-dom");
var _tooltip = _interopRequireDefault(require("./tooltip.style"));
var _tooltipPointer = _interopRequireDefault(require("./tooltip-pointer.style"));
var _tooltip2 = require("./tooltip.config");
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _portal = _interopRequireDefault(require("../portal"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
function preserveRef(ref, node) {
  if (!ref) return;
  if (typeof ref === "function") {
    ref(node);
  }
  if (typeof ref === "object" && "current" in ref) {
    ref.current = node;
  }
}
const TOOLTIP_DELAY = 100;
const Tooltip = exports.Tooltip = /*#__PURE__*/_react.default.forwardRef(({
  children,
  isVisible,
  position = "top",
  message,
  type,
  size = "medium",
  isPartOfInput,
  inputSize = "medium",
  id,
  bgColor,
  fontColor,
  flipOverrides,
  target,
  ...rest
}, ref) => {
  const targetInternalRef = (0, _react.useRef)(null);
  const isControlled = isVisible !== undefined;
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  let showTooltip = isOpen;
  if (isControlled) {
    showTooltip = isVisible;
  }
  const showDelayedTimeout = (0, _react.useRef)(undefined);
  const hideDelayedTimeout = (0, _react.useRef)(undefined);
  (0, _react.useEffect)(() => {
    return () => {
      clearTimeout(showDelayedTimeout.current);
      clearTimeout(hideDelayedTimeout.current);
    };
  }, []);
  const show = (0, _react.useCallback)(() => setIsOpen(true), []);
  const hide = (0, _react.useCallback)(() => setIsOpen(false), []);
  const showDelayed = (0, _react.useCallback)(() => {
    showDelayedTimeout.current = window.setTimeout(show, TOOLTIP_DELAY);
  }, [show]);
  const hideDelayed = (0, _react.useCallback)(() => {
    hideDelayedTimeout.current = window.setTimeout(hide, TOOLTIP_DELAY);
  }, [hide]);
  (0, _react.useEffect)(() => {
    const events = {
      mouseenter: showDelayed,
      mouseleave: hideDelayed,
      focus: show,
      blur: hide
    };
    const targetElement = target || targetInternalRef.current;
    if (!isControlled) {
      Object.entries(events).forEach(([event, handler]) => {
        targetElement?.addEventListener(event, handler);
      });
    }
    return () => {
      if (!isControlled) {
        Object.entries(events).forEach(([event, handler]) => {
          targetElement?.removeEventListener(event, handler);
        });
      }
    };
  }, [children, show, showDelayed, hide, hideDelayed, isControlled, target]);
  const flipOverridesRef = (0, _react.useRef)(flipOverrides);
  flipOverridesRef.current = flipOverrides;
  const arrowReference = (0, _react.useRef)(null);
  const calculateOffset = (0, _react.useCallback)(placement => {
    let mainAxisOffset = 9;
    if (isPartOfInput) {
      const offsets = {
        small: 5,
        medium: ["top", "bottom"].includes(placement) ? 6 : 8,
        large: ["top", "bottom"].includes(placement) ? 10 : 12
      };
      mainAxisOffset = offsets[inputSize];
    }
    return mainAxisOffset;
  }, [inputSize, isPartOfInput]);
  const defaultMiddleware = (0, _react.useMemo)(() => [(0, _reactDom.offset)(({
    placement
  }) => ({
    mainAxis: calculateOffset(placement)
  })), (0, _reactDom.flip)({
    fallbackPlacements: flipOverridesRef.current
  }), (0, _reactDom.shift)({
    padding: 5,
    limiter: (0, _reactDom.limitShift)({
      offset: ({
        rects
      }) => ({
        mainAxis: rects.reference.height
      })
    })
  }), (0, _reactDom.arrow)({
    element: arrowReference
  })], [calculateOffset, arrowReference]);
  const {
    x,
    y,
    reference,
    floating,
    strategy,
    placement: currentPlacement,
    middlewareData
  } = (0, _reactDom.useFloating)({
    placement: position,
    middleware: defaultMiddleware,
    whileElementsMounted: _reactDom.autoUpdate
  });
  const tooltipStyle = {
    position: strategy,
    top: y ?? 0,
    left: x ?? 0
  };
  const handleTargetRef = (0, _react.useCallback)(node => {
    reference(target || node);
    targetInternalRef.current = node;
    preserveRef(
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    children.ref, node);
  }, [reference, children, target]);
  const handleFloatingRef = (0, _react.useCallback)(node => {
    floating(node);
    preserveRef(ref, node);
  }, [floating, ref]);
  const staticSide = {
    top: "bottom",
    right: "left",
    bottom: "top",
    left: "right"
  }[currentPlacement.split("-")[0]];
  const {
    x: arrowX,
    y: arrowY
  } = middlewareData.arrow || {};
  const arrowStyle = {
    left: arrowX,
    top: arrowY,
    [staticSide]: "-6px"
  };
  const isFlipOverridesValid = !flipOverrides || Array.isArray(flipOverrides) && flipOverrides.every(placement => _tooltip2.TOOLTIP_POSITIONS.includes(placement));
  !isFlipOverridesValid ? process.env.NODE_ENV !== "production" ? (0, _invariant.default)(false, `The flipOverrides prop supplied to Tooltip must be an array containing some or all of ["top", "bottom", "left", "right"].`) : (0, _invariant.default)(false) : void 0;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.cloneElement(children, {
    ref: handleTargetRef
  }), showTooltip ? /*#__PURE__*/_react.default.createElement(_portal.default, null, /*#__PURE__*/_react.default.createElement(_tooltip.default, _extends({
    "data-element": "tooltip",
    role: "tooltip",
    tabIndex: -1,
    type: type,
    size: size,
    id: id
  }, (0, _tags.default)("tooltip", rest), {
    ref: handleFloatingRef,
    bgColor: bgColor,
    fontColor: fontColor,
    style: tooltipStyle,
    "data-placement": currentPlacement
  }), /*#__PURE__*/_react.default.createElement(_tooltipPointer.default, {
    type: type,
    ref: arrowReference,
    "data-element": "tooltip-pointer",
    bgColor: bgColor,
    style: arrowStyle
  }), message)) : null);
});
if (process.env.NODE_ENV !== "production") {
  Tooltip.propTypes = {
    "bgColor": _propTypes.default.string,
    "children": _propTypes.default.element.isRequired,
    "flipOverrides": _propTypes.default.arrayOf(_propTypes.default.oneOf(["bottom", "left", "right", "top"])),
    "fontColor": _propTypes.default.string,
    "id": _propTypes.default.string,
    "inputSize": _propTypes.default.oneOf(["large", "medium", "small"]),
    "isPartOfInput": _propTypes.default.bool,
    "isVisible": _propTypes.default.bool,
    "message": _propTypes.default.node,
    "position": _propTypes.default.oneOf(["bottom", "left", "right", "top"]),
    "size": _propTypes.default.oneOf(["large", "medium"]),
    "target": function (props, propName) {
      if (props[propName] == null) {
        return null;
      } else if (typeof props[propName] !== 'object' || props[propName].nodeType !== 1) {
        return new Error("Expected prop '" + propName + "' to be of type Element");
      }
    },
    "type": _propTypes.default.string
  };
}
Tooltip.displayName = "Tooltip";
var _default = exports.default = Tooltip;