"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _color = require("../../style/utils/color");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const pointerColor = (theme, bgColor, type) => {
  if (bgColor) return (0, _color.toColor)(theme, bgColor);
  return type === "error" ? "var(--colorsSemanticNegative500)" : "var(--colorsSemanticNeutral500)";
};
const StyledTooltipPointer = _styledComponents.default.div`
  ${({
  theme,
  type,
  bgColor
}) => (0, _styledComponents.css)`
    z-index: ${theme.zIndex.popover}; // TODO (tokens): implement elevation tokens - FE-4437
    background: ${pointerColor(theme, bgColor, type)};
    position: absolute;
    width: 12px;
    height: 12px;
    transform: rotate(45deg);
  `}
`;
StyledTooltipPointer.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledTooltipPointer;