"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToastWrapper = exports.StyledToastContent = exports.StyledToast = exports.StyledPortal = void 0;
Object.defineProperty(exports, "TypeIcon", {
  enumerable: true,
  get: function () {
    return _typeIcon.default;
  }
});
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _typeIcon = _interopRequireDefault(require("../message/type-icon/type-icon.style"));
var _iconButton = _interopRequireDefault(require("../icon-button/icon-button.style"));
var _portal = _interopRequireDefault(require("../portal/portal"));
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _icon = _interopRequireDefault(require("../icon/icon.style"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledPortal = exports.StyledPortal = (0, _styledComponents.default)(_portal.default)`
  ${({
  theme,
  isCenter,
  isNotice,
  align,
  alignY
}) => (0, _styledComponents.css)`
    position: fixed;
    top: 0;
    z-index: ${theme.zIndex.notification};

    ${isCenter && (0, _styledComponents.css)`
      margin-left: 50%;
      transform: translateX(-50%);
    `}

    ${align === "left" && (0, _styledComponents.css)`
      left: 0;
      transform: translateX(50%);
    `}

    ${align === "center" && (0, _styledComponents.css)`
      margin-left: 50%;
      transform: translateX(-50%);
    `}

    ${align === "right" && (0, _styledComponents.css)`
      right: 0;
      transform: translateX(-50%);
    `}

    ${isNotice && (0, _styledComponents.css)`
      bottom: 0;
      top: auto;
      width: 100%;
    `}

    ${alignY === "top" && (0, _styledComponents.css)`
      top: 0;
      bottom: auto;
    `}

    ${alignY === "center" && (0, _styledComponents.css)`
      top: 50%;
      transform: translate(${align === "left" ? "50%" : "-50%"}, -50%);
    `}

    ${alignY === "bottom" && (0, _styledComponents.css)`
      bottom: 0;
      top: auto;
      display: flex;
      flex-direction: column-reverse;
    `}
  `}
`;
StyledPortal.defaultProps = {
  theme: _base.default
};
const animationName = ".toast";
const alternativeAnimationName = ".toast-alternative";
const ToastColourVariants = {
  error: "var(--colorsSemanticNegative500)",
  info: "var(--colorsSemanticInfo500)",
  success: "var(--colorsSemanticPositive500)",
  warning: "var(--colorsSemanticCaution500)",
  neutral: "var(--colorsSemanticNeutral500)"
};
const boxShadow = "0 10px 30px 0 rgba(0, 20, 29, 0.1), 0 30px 60px 0 rgba(0, 20, 29, 0.1)";
const iconPositionStyles = (0, _styledComponents.css)`
  position: absolute;
  right: 15px;
  top: 50%;
  transform: translateY(-50%);
`;
const StyledToast = exports.StyledToast = _styledComponents.default.div`
  ${({
  maxWidth,
  isCenter,
  align,
  isNotification,
  alignY,
  isNotice,
  variant
}) => (0, _styledComponents.css)`
    position: relative;
    display: flex;
    justify-content: flex-start;
    align-content: center;
    border-radius: var(--borderRadius100);
    overflow: hidden;
    border: 1px solid ${ToastColourVariants[variant]};
    background-color: var(--colorsUtilityYang100);
    min-height: 38px;

    :focus {
      outline: none;
    }

    ${_iconButton.default} {
      ${iconPositionStyles}
    }

    box-shadow: ${boxShadow};
    line-height: 22px;
    margin-top: ${alignY === "top" && isNotice || alignY === "center" ? "0" : "30px"};
    margin-bottom: ${alignY === "bottom" && !isNotice ? "30px" : "0"};
    max-width: ${!maxWidth ? "300px" : maxWidth};
    position: relative;
    margin-right: ${isCenter || align === "right" ? "auto" : "30px"};
    margin-left: ${isCenter || align === "left" ? "auto" : "30px"};

    ${isNotification && (0, _styledComponents.css)`
      border: 1px solid var(--colorsSemanticInfo500);
    `}
  `}

  :focus {
    outline: none;
  }

  &${animationName}-appear, &${animationName}-enter {
    opacity: 0;
    transform: scale(0.5);
  }

  &${animationName}-appear${animationName}-appear-active,
    &${animationName}-enter${animationName}-enter-active {
    opacity: 1;
    transform: ${({
  isCenter
}) => isCenter ? " scale(1) translateY(0)" : "scale(1)"};
    transition: all 300ms cubic-bezier(0.25, 0.25, 0, 1.5);
  }

  &${animationName}-exit${animationName}-exit-active {
    opacity: 0;

    ${({
  alignY
}) => alignY === "bottom" ? "margin-bottom: -40px" : "margin-top: -40px"};
    transition: all 150ms ease-out;
  }

  ${_iconButton.default} {
    ${iconPositionStyles}
  }

  ${({
  isNotice,
  alignY
}) => isNotice && (0, _styledComponents.css)`
      background-color: var(--colorsUtilityMajor400);
      border: none;
      color: var(--colorsSemanticNeutralYang100);
      margin-right: 0;
      max-width: 100%;

      ${_iconButton.default} {
        right: 55px;
      }

      ${_iconButton.default} ${_icon.default} {
        color: var(--colorsSemanticNeutralYang100);
      }

      &${alternativeAnimationName}-appear, &${alternativeAnimationName}-enter {
        ${alignY === "top" ? "top: -40px" : "bottom: -40px"};
        opacity: 0;
      }

      &${alternativeAnimationName}-exit {
        ${alignY === "top" ? "top: 0" : "bottom: 0"};
        opacity: 1;
      }

      &${alternativeAnimationName}-appear${alternativeAnimationName}-appear-active,
        &${alternativeAnimationName}-enter${alternativeAnimationName}-enter-active {
        ${alignY === "top" ? "top: 0" : "bottom: 0"};
        opacity: 1;
        transition: all 400ms ease;
      }

      &${alternativeAnimationName}-exit${alternativeAnimationName}-exit-active {
        ${alignY === "top" ? "top: -40px" : "bottom: -40px"};
        opacity: 0;
        transition: all 200ms ease;
      }
    `}
`;
const StyledToastContent = exports.StyledToastContent = _styledComponents.default.div`
  padding: 8px 16px 8px 16px;
  white-space: pre-wrap;
  flex: 1;

  ${({
  isNotice
}) => isNotice && (0, _styledComponents.css)`
      display: flex;
      align-items: center;
      padding: 11px 40px;
    `}

  ${({
  isDismiss,
  isNotice
}) => isDismiss && (0, _styledComponents.css)`
      padding-right: ${isNotice ? "88px" : "48px"};
    `}
`;
const ToastWrapper = exports.ToastWrapper = _styledComponents.default.div`
  ${({
  align
}) => align && (0, _styledComponents.css)`
      position: relative;
      width: auto;
      height: auto;
      justify-content: ${align};
      display: flex;
    `}

  ${({
  isCenter
}) => isCenter && (0, _styledComponents.css)`
      position: relative;
      width: auto;
      height: auto;
      justify-content: center;
      display: flex;
    `}

  ${({
  isNotice
}) => isNotice && (0, _styledComponents.css)`
      display: block;
    `}
`;