"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Toast = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactTransitionGroup = require("react-transition-group");
var _icon = _interopRequireDefault(require("../icon"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _toast = require("./toast.style");
var _iconButton = _interopRequireDefault(require("../icon-button"));
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _useModalManager = _interopRequireDefault(require("../../hooks/__internal__/useModalManager"));
var _logger = _interopRequireDefault(require("../../__internal__/utils/logger"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let isDeprecationWarningTriggered = false;
const Toast = exports.Toast = /*#__PURE__*/_react.default.forwardRef(({
  align,
  alignY,
  children,
  className,
  id,
  isCenter = true,
  maxWidth,
  onDismiss,
  open = true,
  targetPortalId,
  timeout,
  variant = "success",
  disableAutoFocus,
  closeButtonDataProps,
  ...restProps
}, ref) => {
  const isNotice = variant === "notice";
  const isNotification = variant === "notification";
  const locale = (0, _useLocale.default)();
  const toastRef = (0, _react.useRef)(null);
  const timer = (0, _react.useRef)(null);
  const toastContentNodeRef = (0, _react.useRef)(null);
  const closeIconRef = (0, _react.useRef)(null);
  const focusedElementBeforeOpening = (0, _react.useRef)(null);
  const [tabIndex, setTabIndex] = (0, _react.useState)(0);
  let refToPass = toastRef;
  if (ref && typeof ref === "object" && "current" in ref) {
    refToPass = ref;
  }
  if (isCenter !== undefined && !isDeprecationWarningTriggered) {
    isDeprecationWarningTriggered = true;
    _logger.default.deprecate(`isCenter prop in ${Toast.displayName} is being deprecated in favour of the align prop.`);
  }
  const dismissToast = (0, _react.useCallback)(ev => {
    if (onDismiss && _events.default.isEscKey(ev)) {
      ev.stopImmediatePropagation();
      onDismiss(ev);
    }
  }, [onDismiss]);
  (0, _useModalManager.default)({
    open,
    closeModal: dismissToast,
    modalRef: refToPass,
    topModalOverride: true
  });
  (0, _react.useEffect)(() => {
    /* istanbul ignore next */
    if (timer.current) clearTimeout(timer.current);
    if (!timeout || !open || !onDismiss) {
      return;
    }
    timer.current = setTimeout(() => onDismiss(), +timeout);
  }, [onDismiss, open, timeout]);
  (0, _react.useEffect)(() => {
    if (!disableAutoFocus) {
      if (open) {
        // setTimeout needed as otherwise this runs before the ref is populated
        setTimeout(() => {
          focusedElementBeforeOpening.current = document.activeElement;
          toastContentNodeRef.current?.focus();
        }, 0);
      } else if (focusedElementBeforeOpening.current) {
        focusedElementBeforeOpening.current.focus();
        focusedElementBeforeOpening.current = null;
        setTabIndex(0);
      }
    }
  }, [open, onDismiss, disableAutoFocus]);
  (0, _react.useEffect)(() => {
    return () => {
      if (focusedElementBeforeOpening.current) {
        focusedElementBeforeOpening.current.focus();
      }
    };
  }, []);
  function renderCloseIcon() {
    if (!onDismiss) return null;
    return /*#__PURE__*/_react.default.createElement(_iconButton.default, _extends({
      "aria-label": locale.toast.ariaLabels.close(),
      onClick: onDismiss,
      ref: closeIconRef
    }, (0, _tags.default)("close", {
      "data-element": "close",
      ...closeButtonDataProps
    })), /*#__PURE__*/_react.default.createElement(_icon.default, {
      type: "close"
    }));
  }
  const iconToRender = {
    notification: "alert",
    neutral: "info",
    success: "tick_circle",
    error: "error",
    info: "info",
    warning: "warning"
  };
  const toastIcon = iconToRender[variant] || "none";
  function renderToastContent() {
    if (!open) return null;
    let toastVariant = "success";
    if (!isNotice && !isNotification) {
      toastVariant = variant;
    }
    return /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.CSSTransition, {
      enter: true,
      classNames: isNotice ? "toast-alternative" : "toast",
      timeout: {
        appear: 1600,
        enter: 1500,
        exit: 500
      },
      nodeRef: toastContentNodeRef
    }, /*#__PURE__*/_react.default.createElement(_toast.StyledToast, _extends({
      align: align,
      alignY: alignY,
      isNotice: isNotice,
      isNotification: isNotification,
      className: className
    }, (0, _tags.default)(restProps["data-component"] || "toast", restProps), {
      isCenter: isCenter,
      variant: toastVariant,
      id: id,
      maxWidth: maxWidth,
      ref: toastContentNodeRef
    }, !disableAutoFocus && {
      tabIndex,
      onBlur: () => setTabIndex(undefined)
    }), !isNotice && /*#__PURE__*/_react.default.createElement(_toast.TypeIcon, {
      variant: isNotification ? "info" : variant
    }, /*#__PURE__*/_react.default.createElement(_icon.default, {
      type: toastIcon
    })), /*#__PURE__*/_react.default.createElement(_toast.StyledToastContent, {
      isNotice: isNotice,
      isDismiss: !!onDismiss
    }, children), renderCloseIcon()));
  }
  return /*#__PURE__*/_react.default.createElement(_toast.StyledPortal, {
    id: targetPortalId,
    align: align,
    alignY: alignY,
    isCenter: isCenter,
    isNotice: isNotice
  }, /*#__PURE__*/_react.default.createElement(_toast.ToastWrapper, {
    align: align,
    isCenter: isCenter,
    ref: refToPass,
    isNotice: isNotice
  }, /*#__PURE__*/_react.default.createElement(_reactTransitionGroup.TransitionGroup, null, renderToastContent())));
});
if (process.env.NODE_ENV !== "production") {
  Toast.propTypes = {
    "align": _propTypes.default.oneOf(["center", "left", "right"]),
    "alignY": _propTypes.default.oneOf(["bottom", "center", "top"]),
    "children": _propTypes.default.node,
    "className": _propTypes.default.string,
    "closeButtonDataProps": _propTypes.default.shape({
      "data-element": _propTypes.default.string,
      "data-role": _propTypes.default.string
    }),
    "data-component": _propTypes.default.string,
    "disableAutoFocus": _propTypes.default.bool,
    "id": _propTypes.default.string,
    "isCenter": _propTypes.default.bool,
    "maxWidth": _propTypes.default.string,
    "onDismiss": _propTypes.default.func,
    "open": _propTypes.default.bool,
    "targetPortalId": _propTypes.default.string,
    "timeout": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "variant": _propTypes.default.oneOf(["error", "info", "neutral", "notice", "notification", "success", "warning"])
  };
}
Toast.displayName = "Toast";
var _default = exports.default = Toast;