import React from "react";
import { TagProps } from "../../__internal__/utils/helpers/tags/tags";
declare type ToastVariants = "error" | "info" | "success" | "warning" | "notice" | "neutral" | "notification";
declare type AlignOptions = "left" | "center" | "right";
declare type AlignYOptions = "top" | "center" | "bottom";
export interface ToastProps {
    /** Sets the horizontal alignment of the component. */
    align?: AlignOptions;
    /** Sets the vertical alignment of the component */
    alignY?: AlignYOptions;
    /** The rendered children of the component. */
    children: React.ReactNode;
    /** Customizes the appearance in the DLS theme */
    variant?: ToastVariants;
    /** Custom className */
    className?: string;
    /** Custom id  */
    id?: string;
    /** Component name */
    "data-component"?: string;
    /** Determines if the Toast is open. */
    open?: boolean;
    /** Callback for when dismissed. */
    onDismiss?: (ev?: KeyboardEvent | React.KeyboardEvent<HTMLButtonElement> | React.MouseEvent<HTMLButtonElement>) => void;
    /** Data tag prop bag for close Button */
    closeButtonDataProps?: Pick<TagProps, "data-role" | "data-element">;
    /** Time for Toast to remain on screen */
    timeout?: string | number;
    /** Centers the Toast on the screen */
    isCenter?: boolean;
    /** Target Portal ID where the Toast will render */
    targetPortalId?: string;
    /** Maximum toast width */
    maxWidth?: string;
    /** Disables auto focus functionality when the Toast has a close icon */
    disableAutoFocus?: boolean;
}
export declare const Toast: React.ForwardRefExoticComponent<ToastProps & React.RefAttributes<HTMLDivElement>>;
export default Toast;
