"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _useInputAccessibility = _interopRequireDefault(require("../../hooks/__internal__/useInputAccessibility"));
var _fieldset = _interopRequireDefault(require("../../__internal__/fieldset"));
var _box = _interopRequireDefault(require("../box"));
var _textbox = require("../textbox/textbox.style");
var _validationMessage = _interopRequireDefault(require("../../__internal__/validation-message"));
var _number = _interopRequireDefault(require("../number"));
var _typography = _interopRequireDefault(require("../typography"));
var _time = require("./time.style");
var _timeToggle = require("./__internal__/time-toggle");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Time = /*#__PURE__*/_react.default.forwardRef(({
  label,
  size = "medium",
  inputHint,
  hoursInputProps = {},
  minutesInputProps = {},
  value,
  name,
  onChange,
  onBlur,
  required,
  isOptional,
  disabled,
  readOnly,
  toggleProps = {},
  ...rest
}, ref) => {
  const {
    id: hoursInputId,
    label: hoursLabel,
    "aria-label": hoursAriaLabel,
    error: hoursError,
    warning: hoursWarning
  } = hoursInputProps;
  const {
    id: minutesInputId,
    label: minutesLabel,
    "aria-label": minutesAriaLabel,
    error: minutesError,
    warning: minutesWarning
  } = minutesInputProps;
  const internalHrsId = (0, _react.useRef)(hoursInputId || (0, _guid.default)());
  const internalMinsId = (0, _react.useRef)(minutesInputId || (0, _guid.default)());
  const inputHintId = (0, _react.useRef)((0, _guid.default)());
  const internalId = (0, _react.useRef)(`${internalHrsId.current} ${internalMinsId.current}`);
  const {
    hours: hourValue,
    minutes: minuteValue,
    period: toggleValue
  } = value;
  const [inputValues, setInputValues] = (0, _react.useState)([hourValue, minuteValue]);
  const locale = (0, _useLocale.default)();
  const showToggle = toggleValue !== undefined;
  const [period, setPeriod] = (0, _react.useState)(toggleValue);
  const hrsLabel = hoursLabel || locale.time.hoursLabelText();
  const minsLabel = minutesLabel || locale.time.minutesLabelText();
  const hrsAriaLabel = hoursAriaLabel || locale.time.hoursAriaLabelText();
  const minsAriaLabel = minutesAriaLabel || locale.time.minutesAriaLabelText();
  const hoursRef = (0, _react.useRef)(null);
  const minsRef = (0, _react.useRef)(null);
  const computedValidations = (hrs, mins) => {
    const hoursIsString = typeof hrs === "string";
    const minutesIsString = typeof mins === "string";
    if (!hoursIsString && !minutesIsString) {
      return hrs || mins;
    }
    if (hoursIsString && !minutesIsString) {
      return hrs;
    }
    if (minutesIsString && !hoursIsString) {
      return mins;
    }
    return `${hrs} ${mins}`;
  };
  const error = computedValidations(hoursError, minutesError);
  const warning = computedValidations(hoursWarning, minutesWarning);
  const hasValidationFailure = !!(error || warning);
  const {
    validationId,
    ariaDescribedBy
  } = (0, _useInputAccessibility.default)({
    id: internalId.current,
    validationRedesignOptIn: true,
    error,
    warning
  });
  const combinedAriaDescribedBy = [ariaDescribedBy, inputHintId.current].filter(Boolean).join(" ");
  (0, _react.useImperativeHandle)(ref, () => ({
    focusHoursInput() {
      hoursRef.current?.focus();
    },
    focusMinutesInput() {
      minsRef.current?.focus();
    }
  }), []);
  const handleChange = (ev, inputName) => {
    const hours = inputName === "hrs" ? ev.target.value : inputValues[0];
    const minutes = inputName === "mins" ? ev.target.value : inputValues[1];
    setInputValues([hours, minutes]);
    onChange({
      target: {
        name,
        id: internalId.current,
        value: {
          hours,
          minutes,
          period
        }
      }
    });
  };
  const handlePeriodChange = periodName => {
    const [hours, minutes] = inputValues;
    setPeriod(periodName);
    onChange({
      target: {
        name,
        id: internalId.current,
        value: {
          hours,
          minutes,
          period: periodName
        }
      }
    });
  };
  const handleBlur = (0, _react.useCallback)(ev => {
    setTimeout(() => {
      if (hoursRef.current !== document.activeElement && minsRef.current !== document.activeElement) {
        onBlur?.(ev);
      }
    });
  }, [onBlur]);
  return /*#__PURE__*/_react.default.createElement(_fieldset.default, _extends({
    legend: label,
    legendMargin: {
      mb: 0
    },
    width: "fit-content",
    isRequired: required,
    isOptional: isOptional,
    isDisabled: disabled,
    name: name,
    id: internalId.current
  }, rest, (0, _tags.default)("time", rest), {
    "aria-describedby": combinedAriaDescribedBy
  }), inputHint && /*#__PURE__*/_react.default.createElement(_time.StyledHintText, {
    id: inputHintId.current,
    isDisabled: disabled
  }, inputHint), /*#__PURE__*/_react.default.createElement(_box.default, {
    position: "relative"
  }, /*#__PURE__*/_react.default.createElement(_validationMessage.default, {
    validationId: validationId,
    error: error,
    warning: warning
  }), hasValidationFailure && /*#__PURE__*/_react.default.createElement(_textbox.ErrorBorder, {
    warning: !!(!error && warning)
  }), /*#__PURE__*/_react.default.createElement(_box.default, {
    display: "flex"
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_time.StyledLabel, {
    "aria-label": hrsAriaLabel,
    htmlFor: internalHrsId.current,
    disabled: disabled
  }, hrsLabel), /*#__PURE__*/_react.default.createElement(_number.default, _extends({}, hoursInputProps, {
    label: undefined,
    "data-component": "hours",
    ref: hoursRef,
    value: hourValue,
    onChange: ev => handleChange(ev, "hrs"),
    onBlur: handleBlur,
    id: internalHrsId.current,
    size: size,
    error: !!hoursError,
    warning: !!hoursWarning,
    disabled: disabled,
    readOnly: readOnly
  }))), /*#__PURE__*/_react.default.createElement(_box.default, {
    display: "flex",
    flexDirection: "column",
    justifyContent: "center",
    mx: 1,
    "aria-hidden": "true"
  }, /*#__PURE__*/_react.default.createElement("span", null, "\xA0"), /*#__PURE__*/_react.default.createElement(_typography.default, {
    isDisabled: disabled,
    variant: "span",
    mb: "-4px"
  }, ":")), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_time.StyledLabel, {
    "aria-label": minsAriaLabel,
    htmlFor: internalMinsId.current,
    disabled: disabled
  }, minsLabel), /*#__PURE__*/_react.default.createElement(_number.default, _extends({}, minutesInputProps, {
    label: undefined,
    "data-component": "minutes",
    ref: minsRef,
    value: minuteValue,
    onChange: ev => handleChange(ev, "mins"),
    onBlur: handleBlur,
    id: internalMinsId.current,
    size: size,
    error: !!minutesError,
    warning: !!minutesWarning,
    disabled: disabled,
    readOnly: readOnly
  }))), showToggle && /*#__PURE__*/_react.default.createElement(_box.default, {
    display: "flex",
    flexDirection: "column",
    justifyContent: "flex-end"
  }, /*#__PURE__*/_react.default.createElement(_timeToggle.TimeToggle, {
    toggleProps: toggleProps,
    size: size,
    onChange: handlePeriodChange,
    toggleValue: toggleValue,
    disabled: disabled || readOnly
  })))));
});
if (process.env.NODE_ENV !== "production") {
  Time.propTypes = {
    "children": _propTypes.default.node,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "disabled": _propTypes.default.bool,
    "hoursInputProps": _propTypes.default.shape({
      "aria-label": _propTypes.default.string,
      "data-element": _propTypes.default.string,
      "data-role": _propTypes.default.string,
      "error": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
      "id": _propTypes.default.string,
      "label": _propTypes.default.string,
      "warning": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool])
    }),
    "inputHint": _propTypes.default.string,
    "isOptional": _propTypes.default.bool,
    "label": _propTypes.default.string,
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "minutesInputProps": _propTypes.default.shape({
      "aria-label": _propTypes.default.string,
      "data-element": _propTypes.default.string,
      "data-role": _propTypes.default.string,
      "error": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
      "id": _propTypes.default.string,
      "label": _propTypes.default.string,
      "warning": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool])
    }),
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "name": _propTypes.default.string,
    "onBlur": _propTypes.default.func,
    "onChange": _propTypes.default.func.isRequired,
    "readOnly": _propTypes.default.bool,
    "required": _propTypes.default.bool,
    "size": _propTypes.default.oneOf(["large", "medium", "small"]),
    "toggleProps": _propTypes.default.shape({
      "amToggleProps": _propTypes.default.shape({
        "data-element": _propTypes.default.string,
        "data-role": _propTypes.default.string
      }),
      "pmToggleProps": _propTypes.default.shape({
        "data-element": _propTypes.default.string,
        "data-role": _propTypes.default.string
      }),
      "wrapperProps": _propTypes.default.shape({
        "data-element": _propTypes.default.string,
        "data-role": _propTypes.default.string
      })
    }),
    "value": _propTypes.default.shape({
      "hours": _propTypes.default.string.isRequired,
      "minutes": _propTypes.default.string.isRequired,
      "period": _propTypes.default.oneOf(["AM", "PM"])
    }).isRequired
  };
}
Time.displayName = "Time";
var _default = exports.default = Time;