import React from "react";
import { MarginProps } from "styled-system";
import { ValidationProps } from "../../__internal__/validations";
import { TagProps } from "../../__internal__/utils/helpers/tags";
import { Sizes } from "../../__internal__/input/input-presentation.component";
import { ToggleDataProps } from "./__internal__/time-toggle";
export declare type ToggleValue = "AM" | "PM";
export declare type TimeValue = {
    hours: string;
    minutes: string;
    period?: ToggleValue;
};
export interface TimeInputEvent {
    target: {
        name?: string;
        id: string;
        value: TimeValue;
    };
}
interface TimeInputProps extends Omit<TagProps, "data-component">, Omit<ValidationProps, "info"> {
    /** Set an id value on the input */
    id?: string;
    /** Override the default label text */
    label?: string;
    /** Override the default aria-label text */
    "aria-label"?: string;
}
export interface TimeProps extends Omit<TagProps, "data-component">, MarginProps {
    /** Label text for the component */
    label?: string;
    /** Sets the size of the inputs */
    size?: Sizes;
    /** Additional hint text rendered above the input elements */
    inputHint?: string;
    /**
     * Set custom `data-` and `id` attributes on the input element.
     * Set the `label` and `aria-label` values for the associated Label element.
     * Set the `error` and `warning` states for the input
     *  */
    hoursInputProps?: TimeInputProps;
    /**
     * Set custom `data-` and `id` attributes on the input element.
     * Set the `label` and `aria-label` values for the associated Label element.
     * Set the `error` and `warning` states for the input
     *  */
    minutesInputProps?: TimeInputProps;
    /** The value of the input elements */
    value: TimeValue;
    /** Callback to handle change events in input elements */
    onChange: (ev: TimeInputEvent) => void;
    /** Set a name value on the component */
    name?: string;
    /** Callback called when focus is lost on input elements */
    onBlur?: (ev?: React.FocusEvent<HTMLInputElement>) => void;
    /** Flag to configure component as mandatory */
    required?: boolean;
    /** Flag to configure component as optional */
    isOptional?: boolean;
    /** If true, the component will be disabled */
    disabled?: boolean;
    /** If true, the component will be read-only */
    readOnly?: boolean;
    /** Set custom data- attributes on the toggle elements */
    toggleProps?: ToggleDataProps;
}
export declare type TimeHandle = {
    /** Programmatically focus the hours input. */
    focusHoursInput: () => void;
    /** Programmatically focus the minutes input. */
    focusMinutesInput: () => void;
} | null;
declare const Time: React.ForwardRefExoticComponent<TimeProps & React.RefAttributes<TimeHandle>>;
export default Time;
