"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _guid = _interopRequireDefault(require("../../../../__internal__/utils/helpers/guid"));
var _useLocale = _interopRequireDefault(require("../../../../hooks/__internal__/useLocale"));
var _buttonToggle = require("../../../button-toggle");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Toggle = ({
  size,
  onChange,
  toggleValue,
  disabled,
  toggleProps
}) => {
  const locale = (0, _useLocale.default)();
  const amText = locale.time.amText();
  const pmText = locale.time.pmText();
  const internalId = (0, _react.useRef)((0, _guid.default)());
  const {
    wrapperProps,
    amToggleProps,
    pmToggleProps
  } = toggleProps || /* istanbul ignore next */{};
  const handleChange = (0, _react.useCallback)(event => {
    const selectedButtonValue = event.target.value;
    if (selectedButtonValue !== toggleValue) {
      onChange(selectedButtonValue);
    }
  }, [toggleValue, onChange]);
  return /*#__PURE__*/_react.default.createElement(_buttonToggle.ButtonToggleGroup, _extends({}, wrapperProps, {
    "data-component": "time-button-toggle-group",
    m: "0px 0px 0px 16px",
    id: internalId.current,
    onChange: handleChange,
    value: toggleValue,
    disabled: disabled
  }), /*#__PURE__*/_react.default.createElement(_buttonToggle.ButtonToggle, _extends({}, amToggleProps, {
    "data-component": "am-button-toggle",
    value: "AM",
    size: size
  }), amText), /*#__PURE__*/_react.default.createElement(_buttonToggle.ButtonToggle, _extends({}, pmToggleProps, {
    "data-component": "pm-button-toggle",
    value: "PM",
    size: size
  }), pmText));
};
Toggle.displayName = "Toggle";
var _default = exports.default = Toggle;