"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _elementSizing = _interopRequireDefault(require("../../style/utils/element-sizing"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getBorderColor = (borderVariant, variant) => {
  switch (borderVariant) {
    case "selected":
      return "var(--colorsUtilityYin100)";
    case "positive":
      return "var(--colorsSemanticPositive500)";
    case "negative":
      return "var(--colorsSemanticNegative500)";
    case "caution":
      return "var(--colorsSemanticCaution500)";
    case "info":
      return "var(--colorsSemanticInfo500)";
    default:
      switch (variant) {
        case "active":
          return "var(--colorsActionMajor500)";
        case "grey":
          return "var(--colorsUtilityMajor200)";
        default:
          return "var(--colorsUtilityMajor100)";
      }
  }
};
const getBorderRadius = roundness => {
  switch (roundness) {
    case "large":
      return "var(--borderRadius200)";
    case "small":
      return "var(--borderRadius050)";
    default:
      return "var(--borderRadius100)";
  }
};
const StyledTile = _styledComponents.default.div`
  ${({
  borderVariant,
  borderWidth = "borderWidth100",
  isHorizontal,
  variant,
  width,
  roundness,
  height
}) => (0, _styledComponents.css)`
    ${_styledSystem.space}

    box-sizing: border-box;
    border: var(--${borderWidth}) solid
      ${getBorderColor(borderVariant, variant)};
    border-radius: ${getBorderRadius(roundness)};
    --tileBorderRadius: ${getBorderRadius(roundness)};

    > *:first-child {
      border-top-left-radius: calc(${getBorderRadius(roundness)} - 1px);
      border-top-right-radius: calc(${getBorderRadius(roundness)} - 1px);
    }

    > *:last-child {
      border-bottom-left-radius: calc(${getBorderRadius(roundness)} - 1px);
      border-bottom-right-radius: calc(${getBorderRadius(roundness)} - 1px);
    }

    ${variant === "tile" && (0, _styledComponents.css)`
      background-color: var(--colorsUtilityYang100);
    `}

    ${variant === "transparent" && (0, _styledComponents.css)`
      background-color: transparent;
    `}

    ${variant === "active" && (0, _styledComponents.css)`
      background-color: var(--colorsActionMajor025);
    `}

    ${variant === "grey" && (0, _styledComponents.css)`
      background-color: var(--colorsUtilityMajor025);
    `}

    display: flex;
    flex-direction: ${isHorizontal ? "row" : "column"};
    position: relative;
    ${(0, _elementSizing.default)({
  width: width || /* istanbul ignore next */undefined,
  height: height || undefined
})}
  `}
`;
StyledTile.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledTile;