"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Tile = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tile = _interopRequireDefault(require("./tile.style"));
var _tileContext = _interopRequireDefault(require("./__internal__/tile-context"));
var _filterStyledSystemPaddingProps = _interopRequireDefault(require("../../style/utils/filter-styled-system-padding-props"));
var _filterStyledSystemMarginProps = _interopRequireDefault(require("../../style/utils/filter-styled-system-margin-props"));
var _computeContentPadding = _interopRequireDefault(require("./__internal__/compute-content-padding"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const Tile = ({
  variant = "tile",
  p = 3,
  children,
  orientation = "horizontal",
  width = "100%",
  roundness = "default",
  height,
  borderWidth,
  borderVariant,
  ...rest
}) => {
  const isHorizontal = orientation === "horizontal";
  const paddingProps = (0, _filterStyledSystemPaddingProps.default)({
    p,
    ...rest
  });
  const marginProps = (0, _filterStyledSystemMarginProps.default)(rest);
  const contentPaddingProps = (0, _computeContentPadding.default)(paddingProps, isHorizontal);
  return /*#__PURE__*/_react.default.createElement(_tile.default, _extends({
    variant: variant,
    width: width,
    height: height,
    isHorizontal: isHorizontal,
    p: p,
    roundness: roundness,
    borderWidth: borderWidth,
    borderVariant: borderVariant
  }, paddingProps, marginProps, (0, _tags.default)("tile", rest)), /*#__PURE__*/_react.default.createElement(_tileContext.default.Provider, {
    value: {
      isHorizontal,
      paddingPropsFromTile: contentPaddingProps
    }
  }, children));
};
exports.Tile = Tile;
var _default = exports.default = Tile;