"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _themes = require("../../../style/themes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getBackgroundColor = variant => {
  switch (variant) {
    case "transparent":
      return "transparent";
    case "black":
      return "var(--colorsUtilityYin100)";
    case "grey":
      return "var(--colorsUtilityMajor025)";
    default:
      return "var(--colorsUtilityMajor100)";
  }
};
const StyledTileFooter = _styledComponents.default.div`
  ${_styledSystem.padding}
  border-bottom-left-radius: calc(var(--tileBorderRadius) - 1px);
  border-bottom-right-radius: calc(var(--tileBorderRadius) - 1px);

  ${({
  variant
}) => (0, _styledComponents.css)`
    background: ${getBackgroundColor(variant)};
    border-top: 1px solid
      ${variant === "grey" ? "var(--colorsUtilityMajor200)" : "var(--colorsUtilityMajor100)"};
  `}
`;
StyledTileFooter.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = StyledTileFooter;