"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../../style/themes/base"));
var _elementSizing = _interopRequireDefault(require("../../../style/utils/element-sizing"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledTileContent = _styledComponents.default.div`
  ${({
  isHorizontal,
  isVertical,
  width,
  height
}) => (0, _styledComponents.css)`
    ${_styledSystem.space}

    box-sizing: border-box;
    position: relative;
    flex-grow: 1;

    ${isHorizontal && (0, _styledComponents.css)`
      display: inline;

      :last-of-type {
        padding-right: 0;
      }

      :first-of-type {
        padding-left: 0;
      }

      & + & {
        margin-top: 0;
        border-left: solid 1px var(--colorsUtilityMajor050);
      }
    `}

    ${isVertical && (0, _styledComponents.css)`
      width: auto;

      :last-of-type {
        padding-bottom: 0;
      }

      :first-of-type {
        padding-top: 0;
      }

      & + & {
        margin-top: 0;
        border-top: solid 1px var(--colorsUtilityMajor050);
      }
    `}

    ${(width || height) && (0, _styledComponents.css)`
      flex-grow: 0;
      ${(0, _elementSizing.default)({
  width: width || /* istanbul ignore next */undefined,
  height: height || undefined
})}
    `}
  `}
`;
StyledTileContent.defaultProps = {
  theme: _base.default
};
var _default = exports.default = StyledTileContent;