"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tileContent = _interopRequireDefault(require("./tile-content.style"));
var _tileContext = _interopRequireDefault(require("../__internal__/tile-context"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags"));
var _filterStyledSystemPaddingProps = _interopRequireDefault(require("../../../style/utils/filter-styled-system-padding-props"));
var _filterStyledSystemMarginProps = _interopRequireDefault(require("../../../style/utils/filter-styled-system-margin-props"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const TileContent = ({
  children,
  width,
  height,
  ...rest
}) => {
  const {
    isHorizontal,
    paddingPropsFromTile
  } = (0, _react.useContext)(_tileContext.default);
  if (!children) {
    return null;
  }
  const spacingProps = {
    ...(0, _filterStyledSystemPaddingProps.default)(rest),
    ...(0, _filterStyledSystemMarginProps.default)(rest)
  };
  return /*#__PURE__*/_react.default.createElement(_tileContent.default, _extends({
    width: width,
    height: height,
    isHorizontal: isHorizontal,
    isVertical: !isHorizontal
  }, paddingPropsFromTile, spacingProps, (0, _tags.default)("tile-content", rest)), children);
};
var _default = exports.default = TileContent;