"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FlexTileContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _box = _interopRequireDefault(require("../../box"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const FlexTileContainer = ({
  children,
  columnGap = 2
}) => {
  if (!children) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  return /*#__PURE__*/_react.default.createElement(_box.default, {
    alignContent: "stretch",
    alignItems: "stretch",
    display: "flex",
    flexDirection: "row",
    flexWrap: "wrap",
    columnGap: columnGap,
    justifyContent: "flex-start",
    overflow: "hidden",
    width: "100%",
    "data-component": "flex-tile-container"
  }, children);
};
exports.FlexTileContainer = FlexTileContainer;
if (process.env.NODE_ENV !== "production") {
  FlexTileContainer.propTypes = {
    "children": _propTypes.default.node,
    "columnGap": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string])
  };
}
var _default = exports.default = FlexTileContainer;