"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _filterStyledSystemPaddingProps = require("../../../style/utils/filter-styled-system-padding-props");
const CONTENT_PADDING_LEFT_KEYS = [..._filterStyledSystemPaddingProps.paddingLeftPropertyNames, ..._filterStyledSystemPaddingProps.paddingXPropertyNames, ..._filterStyledSystemPaddingProps.paddingNames];
const CONTENT_PADDING_RIGHT_KEYS = [..._filterStyledSystemPaddingProps.paddingRightPropertyNames, ..._filterStyledSystemPaddingProps.paddingXPropertyNames, ..._filterStyledSystemPaddingProps.paddingNames];
const CONTENT_PADDING_TOP_KEYS = [..._filterStyledSystemPaddingProps.paddingTopPropertyNames, ..._filterStyledSystemPaddingProps.paddingYPropertyNames, ..._filterStyledSystemPaddingProps.paddingNames];
const CONTENT_PADDING_BOTTOM_KEYS = [..._filterStyledSystemPaddingProps.paddingBottomPropertyNames, ..._filterStyledSystemPaddingProps.paddingYPropertyNames, ..._filterStyledSystemPaddingProps.paddingNames];
var _default = (paddingProps, isHorizontal) => {
  const getPaddingProps = paddingKeys => {
    const key = paddingKeys.find(propName => paddingProps[propName]);

    /* istanbul ignore if */
    if (!key) {
      return key;
    }
    return paddingProps[key];
  };
  return isHorizontal ? {
    pr: getPaddingProps(CONTENT_PADDING_LEFT_KEYS),
    pl: getPaddingProps(CONTENT_PADDING_RIGHT_KEYS)
  } : {
    pt: getPaddingProps(CONTENT_PADDING_TOP_KEYS),
    pb: getPaddingProps(CONTENT_PADDING_BOTTOM_KEYS)
  };
};
exports.default = _default;