"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledTitleContainer = exports.StyledTitle = exports.StyledTileSelectInput = exports.StyledTileSelectFieldset = exports.StyledTileSelectContainer = exports.StyledTileSelect = exports.StyledSubtitle = exports.StyledGroupDescription = exports.StyledFooterWrapper = exports.StyledFocusWrapper = exports.StyledDeselectWrapper = exports.StyledDescription = exports.StyledAdornment = exports.StyledAccordionFooterWrapper = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _fieldset = _interopRequireDefault(require("../fieldset"));
var _input = require("../../__internal__/input");
var _fieldset2 = require("../fieldset/fieldset.style");
var _icon = _interopRequireDefault(require("../icon/icon.style"));
var _themes = require("../../style/themes");
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledTitle = exports.StyledTitle = _styledComponents.default.h3`
  font-size: 16px;
  font-weight: 900;
  margin: 0;
  margin-right: 16px;
  margin-bottom: 8px;
  color: var(--colorsActionMinorYin090);
`;
const StyledSubtitle = exports.StyledSubtitle = _styledComponents.default.h4`
  font-size: 14px;
  font-weight: 700;
  margin: 0;
  margin-right: 16px;
  margin-bottom: 8px;
  color: var(--colorsActionMinorYin090);
`;
const StyledAdornment = exports.StyledAdornment = _styledComponents.default.div`
  z-index: 500;
  margin-bottom: ${({
  hasAdditionalInformation
}) => hasAdditionalInformation ? "4" : "8"}px;
`;
const StyledDescription = exports.StyledDescription = _styledComponents.default.p`
  color: var(--colorsActionMinorYin055);
  font-size: 14px;
  margin: 0;
`;
const StyledTileSelect = exports.StyledTileSelect = _styledComponents.default.div`
  background: var(--colorsActionMinorYang100);
  padding: 24px;

  ${({
  checked
}) => checked && (0, _styledComponents.css)`
      background: var(--colorsActionMajor025);
    `}

  ${({
  disabled
}) => disabled && (0, _styledComponents.css)`
      background: var(--colorsActionMinorYang100);
      ${StyledTitle}, ${StyledSubtitle}, ${StyledDescription} {
        color: var(--colorsActionMinorYin030);
      }
      ${StyledAdornment} * {
        opacity: 0.3;
      }
    `}
`;
const oldFocusStyling = `
  outline: solid 3px var(--colorsSemanticFocus500);
`;
const StyledFocusWrapper = exports.StyledFocusWrapper = _styledComponents.default.div`
  ${({
  checked,
  hasFocus,
  theme
}) => (0, _styledComponents.css)`
    position: relative;
    border: 1px solid var(--colorsActionMinor250);
    border-radius: var(--borderRadius100);
    overflow: hidden;

    ${checked && (0, _styledComponents.css)`
      border-color: var(--colorsActionMajor500);
      z-index: 10;
    `}

    ${hasFocus && (0, _styledComponents.css)`
      ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : /* istanbul ignore next */oldFocusStyling}
      z-index: 15;
    `}
  `}
`;
const StyledTileSelectContainer = exports.StyledTileSelectContainer = _styledComponents.default.div`
  ${_styledSystem.margin}

  width: 100%;
  position: relative;

  & + & ${StyledFocusWrapper} {
    margin-top: -1px;
  }
  ${({
  checked,
  disabled
}) => !checked && !disabled && (0, _styledComponents.css)`
      &:hover ${StyledTileSelect} {
        background: var(--colorsActionMinor050);
      }
    `}
`;
const StyledFooterWrapper = exports.StyledFooterWrapper = _styledComponents.default.div`
  width: fit-content;
  position: relative;
  z-index: 200;
`;
const StyledAccordionFooterWrapper = exports.StyledAccordionFooterWrapper = _styledComponents.default.div`
  width: fit-content;
  position: relative;
  z-index: 200;
  left: -12px;

  border-bottom-right-radius: var(--borderRadius100);
  border-bottom-left-radius: var(--borderRadius100);

  ${({
  accordionExpanded
}) => `
      span[data-element="chevron_down"] {
        transition: transform 0.3s;
        ${!accordionExpanded && "transform: rotate(-90deg)"};
      }
  `}
`;
const StyledTileSelectInput = exports.StyledTileSelectInput = (0, _styledComponents.default)(_input.Input)`
  position: absolute;
  top: 0;
  left: 0;
  opacity: 0;
  height: 100%;
  width: 100%;
  margin: 0;
  z-index: 100;
  cursor: ${({
  disabled
}) => disabled ? "not-allowed" : "pointer"};
`;
const StyledTitleContainer = exports.StyledTitleContainer = _styledComponents.default.div`
  display: inline-flex;
  align-items: baseline;
  flex-wrap: wrap;
  margin-right: 16px;
  position: relative;
`;
const StyledDeselectWrapper = exports.StyledDeselectWrapper = _styledComponents.default.div`
  ${({
  hasActionAdornment
}) => (0, _styledComponents.css)`
    z-index: 200;
    position: relative;
    top: -4px;
    right: 8px;
    height: fit-content;

    ${hasActionAdornment && `
      margin-right: var(--sizing200);
      display: flex;
      align-items: baseline;
      min-height: var(--sizing400);

      ${_icon.default} {
        top: 2px;
      }
    `}
  `}
`;
const StyledTileSelectFieldset = exports.StyledTileSelectFieldset = (0, _styledComponents.default)(_fieldset.default)`
  ${_styledSystem.margin}

  ${_fieldset2.StyledLegend} {
    margin-bottom: 16px;
    font-size: 16px;
    line-height: 16px;
    margin-left: -2px;
  }
  ${({
  multiSelect
}) => multiSelect && (0, _styledComponents.css)`
      ${StyledTileSelectContainer} {
        margin-bottom: 8px;
      }
    `}
`;
const StyledGroupDescription = exports.StyledGroupDescription = _styledComponents.default.p`
  color: var(--colorsActionMinorYin055);
  margin: 0;
  margin-bottom: 16px;
`;
StyledTileSelectFieldset.defaultProps = {
  theme: _themes.baseTheme
};
StyledTileSelectContainer.defaultProps = {
  theme: _themes.baseTheme
};