"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../__internal__/utils/helpers/tags/tags"));
var _useLocale = _interopRequireDefault(require("../../hooks/__internal__/useLocale"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _button = _interopRequireDefault(require("../button"));
var _box = _interopRequireDefault(require("../box"));
var _accordion = _interopRequireDefault(require("./__internal__/accordion"));
var _tileSelect = require("./tile-select.style");
var _utils = require("../../style/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const checkPropTypeIsNode = prop => typeof prop !== "string";
const TileSelect = /*#__PURE__*/_react.default.forwardRef(({
  onChange,
  onBlur,
  onFocus,
  value,
  name,
  checked = false,
  className,
  disabled,
  title,
  subtitle,
  description,
  titleAdornment,
  type = "checkbox",
  id,
  customActionButton,
  actionButtonAdornment,
  footer,
  prefixAdornment,
  additionalInformation,
  accordionContent,
  accordionControl,
  accordionExpanded,
  ...rest
}, ref) => {
  const l = (0, _useLocale.default)();
  const [hasFocus, setHasFocus] = (0, _react.useState)(false);
  const handleDeselect = () => onChange?.({
    target: {
      ...(name && {
        name
      }),
      ...(id && {
        id
      }),
      value: null,
      checked: false
    }
  });
  const renderActionButton = () => /*#__PURE__*/_react.default.createElement(_tileSelect.StyledDeselectWrapper, {
    hasActionAdornment: !!actionButtonAdornment
  }, customActionButton && customActionButton(handleDeselect), !customActionButton && checked && /*#__PURE__*/_react.default.createElement(_button.default, {
    buttonType: "tertiary",
    size: "small",
    disabled: disabled,
    onClick: handleDeselect
  }, l.tileSelect.deselect()), actionButtonAdornment);
  (0, _react.useEffect)(() => {
    if (disabled && hasFocus) {
      setHasFocus(false);
    }
  }, [disabled, hasFocus]);
  const guid = (0, _react.useRef)((0, _guid.default)());
  const contentId = `AccordionContent_${guid.current}`;
  const controlId = `AccordionControl_${guid.current}`;
  return /*#__PURE__*/_react.default.createElement(_tileSelect.StyledTileSelectContainer, _extends({
    checked: checked,
    className: className,
    disabled: disabled
  }, (0, _tags.default)("tile-select", rest), (0, _utils.filterStyledSystemMarginProps)(rest)), /*#__PURE__*/_react.default.createElement(_tileSelect.StyledFocusWrapper, {
    hasFocus: hasFocus,
    checked: checked
  }, /*#__PURE__*/_react.default.createElement(_tileSelect.StyledTileSelectInput, _extends({
    onChange: onChange,
    onBlur: ev => {
      setHasFocus(false);
      onBlur?.(ev);
    },
    onFocus: ev => {
      setHasFocus(true);
      onFocus?.(ev);
    },
    checked: checked,
    name: name,
    type: type,
    value: value,
    disabled: disabled,
    "aria-checked": checked,
    id: id,
    ref: ref
  }, rest)), /*#__PURE__*/_react.default.createElement(_tileSelect.StyledTileSelect, {
    disabled: disabled,
    checked: checked
  }, /*#__PURE__*/_react.default.createElement(_box.default, {
    display: "flex",
    justifyContent: "space-between",
    flexDirection: "row-reverse"
  }, (customActionButton || checked) && renderActionButton(), /*#__PURE__*/_react.default.createElement(_box.default, {
    flexGrow: 1
  }, /*#__PURE__*/_react.default.createElement(_tileSelect.StyledTitleContainer, null, title && /*#__PURE__*/_react.default.createElement(_tileSelect.StyledTitle, {
    as: checkPropTypeIsNode(title) ? "div" : undefined
  }, title), subtitle && /*#__PURE__*/_react.default.createElement(_tileSelect.StyledSubtitle, {
    as: checkPropTypeIsNode(subtitle) ? "div" : undefined
  }, subtitle), titleAdornment && /*#__PURE__*/_react.default.createElement(_tileSelect.StyledAdornment, {
    hasAdditionalInformation: !!additionalInformation
  }, titleAdornment && /*#__PURE__*/_react.default.createElement("div", null, titleAdornment))), additionalInformation && /*#__PURE__*/_react.default.createElement("div", null, additionalInformation), /*#__PURE__*/_react.default.createElement(_tileSelect.StyledDescription, {
    as: checkPropTypeIsNode(description) ? "div" : undefined
  }, description), footer && /*#__PURE__*/_react.default.createElement(_tileSelect.StyledFooterWrapper, null, footer), accordionContent && accordionControl && /*#__PURE__*/_react.default.createElement(_tileSelect.StyledAccordionFooterWrapper, {
    accordionExpanded: accordionExpanded
  }, accordionControl(controlId, contentId))), prefixAdornment && /*#__PURE__*/_react.default.createElement(_box.default, {
    "data-element": "prefix-adornment",
    mr: 3,
    opacity: disabled ? "0.3" : undefined
  }, prefixAdornment))), accordionContent && /*#__PURE__*/_react.default.createElement(_accordion.default, {
    contentId: contentId,
    controlId: controlId,
    expanded: accordionExpanded
  }, accordionContent)));
});
if (process.env.NODE_ENV !== "production") {
  TileSelect.propTypes = {
    "accordionContent": _propTypes.default.node,
    "accordionControl": _propTypes.default.func,
    "accordionExpanded": _propTypes.default.bool,
    "actionButtonAdornment": _propTypes.default.node,
    "additionalInformation": _propTypes.default.node,
    "checked": _propTypes.default.bool,
    "className": _propTypes.default.string,
    "customActionButton": _propTypes.default.func,
    "description": _propTypes.default.node,
    "disabled": _propTypes.default.bool,
    "footer": _propTypes.default.node,
    "id": _propTypes.default.string,
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "name": _propTypes.default.string,
    "onBlur": _propTypes.default.func,
    "onChange": _propTypes.default.func,
    "onFocus": _propTypes.default.func,
    "prefixAdornment": _propTypes.default.node,
    "subtitle": _propTypes.default.node,
    "title": _propTypes.default.node,
    "titleAdornment": _propTypes.default.node,
    "type": _propTypes.default.oneOf(["checkbox", "radio"]),
    "value": _propTypes.default.string
  };
}
TileSelect.displayName = "TileSelect";
var _default = exports.default = TileSelect;