"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TileSelectGroup = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _tags = _interopRequireDefault(require("../../../__internal__/utils/helpers/tags/tags"));
var _radioButtonMapper = _interopRequireDefault(require("../../../__internal__/radio-button-mapper/radio-button-mapper.component"));
var _tileSelect = require("../tile-select.style");
var _utils = require("../../../style/utils");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const TileSelectGroup = ({
  children,
  name,
  legend,
  description,
  onChange,
  onBlur,
  value,
  multiSelect = false,
  ...rest
}) => {
  let tiles;
  if (multiSelect) {
    tiles = children;
  } else {
    tiles = /*#__PURE__*/_react.default.createElement(_radioButtonMapper.default, {
      name: name,
      onBlur: onBlur,
      onChange: onChange,
      value: value
    }, _react.default.Children.map(children, child => {
      if ( /*#__PURE__*/_react.default.isValidElement(child)) {
        return /*#__PURE__*/_react.default.cloneElement(child, {
          type: "radio"
        });
      }
      return child;
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_tileSelect.StyledTileSelectFieldset, _extends({
    legend: legend
  }, (0, _tags.default)("tile-select-group", rest), {
    multiSelect: multiSelect
  }, (0, _utils.filterStyledSystemMarginProps)(rest)), description && /*#__PURE__*/_react.default.createElement(_tileSelect.StyledGroupDescription, {
    "data-element": "tile-select-group-description"
  }, description), tiles);
};
exports.TileSelectGroup = TileSelectGroup;
var _default = exports.default = TileSelectGroup;