"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _accordion = require("./accordion.style");
var _useResizeObserver = _interopRequireDefault(require("../../../../hooks/__internal__/useResizeObserver"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Accordion = ({
  children,
  expanded,
  contentId,
  controlId
}) => {
  const [contentHeight, setContentHeight] = (0, _react.useState)(0);
  const contentRef = (0, _react.useRef)(null);
  (0, _useResizeObserver.default)(contentRef, () => {
    // istanbul ignore else
    if (contentRef.current) {
      setContentHeight(contentRef.current.scrollHeight);
    }
  });
  return /*#__PURE__*/_react.default.createElement(_accordion.StyledContentContainer, {
    "aria-expanded": expanded,
    isExpanded: expanded,
    maxHeight: contentHeight
  }, /*#__PURE__*/_react.default.createElement(_accordion.StyledContent, {
    role: "region",
    "data-element": "tile-select-accordion-content",
    ref: contentRef,
    id: contentId,
    "aria-labelledby": controlId
  }, children));
};
var _default = exports.default = Accordion;