"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Textarea = exports.OriginalTextarea = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _input = require("../../__internal__/input");
var _formField = _interopRequireDefault(require("../../__internal__/form-field"));
var _useCharacterCount = _interopRequireDefault(require("../../hooks/__internal__/useCharacterCount"));
var _input2 = _interopRequireDefault(require("../../__internal__/input/input.component"));
var _inputBehaviour = require("../../__internal__/input-behaviour");
var _inputIconToggle = _interopRequireDefault(require("../../__internal__/input-icon-toggle"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _textarea = _interopRequireWildcard(require("./textarea.style"));
var _tooltipProvider = require("../../__internal__/tooltip-provider");
var _useInputAccessibility = _interopRequireDefault(require("../../hooks/__internal__/useInputAccessibility"));
var _carbonProvider = require("../carbon-provider/carbon-provider.component");
var _textbox = require("../textbox/textbox.style");
var _validationMessage = _interopRequireDefault(require("../../__internal__/validation-message"));
var _box = _interopRequireDefault(require("../box"));
var _logger = _interopRequireDefault(require("../../__internal__/utils/logger"));
var _useFormSpacing = _interopRequireDefault(require("../../hooks/__internal__/useFormSpacing"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
let deprecateUncontrolledWarnTriggered = false;
let warnBorderRadiusArrayTooLarge = false;
const Textarea = exports.OriginalTextarea = exports.Textarea = /*#__PURE__*/_react.default.forwardRef(({
  "aria-labelledby": ariaLabelledBy,
  autoFocus,
  inputHint,
  fieldHelp,
  label,
  size,
  children,
  characterLimit,
  onChange,
  disabled = false,
  labelInline,
  labelAlign,
  labelHelp,
  labelSpacing,
  inputIcon,
  id: idProp,
  error,
  warning,
  info,
  name,
  readOnly = false,
  placeholder,
  expandable = false,
  rows,
  cols,
  validationOnLabel = false,
  adaptiveLabelBreakpoint,
  inputWidth,
  maxWidth,
  labelWidth = 30,
  tooltipPosition,
  value,
  "data-component": dataComponent,
  "data-element": dataElement,
  "data-role": dataRole,
  helpAriaLabel,
  borderRadius,
  hideBorders = false,
  required,
  isOptional,
  ...rest
}, ref) => {
  const {
    validationRedesignOptIn
  } = (0, _react.useContext)(_carbonProvider.NewValidationContext);
  const computeLabelPropValues = prop => validationRedesignOptIn ? undefined : prop;
  const {
    current: id
  } = (0, _react.useRef)(idProp || (0, _guid.default)());
  const internalRef = (0, _react.useRef)(null);
  const callbackRef = (0, _react.useCallback)(inputElement => {
    internalRef.current = inputElement;
    if (!ref) {
      return;
    }
    if ("current" in ref) {
      ref.current = inputElement;
    } else {
      ref(inputElement);
    }
  }, [ref]);
  if (!deprecateUncontrolledWarnTriggered && !onChange) {
    deprecateUncontrolledWarnTriggered = true;
    _logger.default.deprecate("Uncontrolled behaviour in `Textarea` is deprecated and support will soon be removed. Please make sure all your inputs are controlled.");
  }
  if (Array.isArray(borderRadius) && borderRadius.length > 4 && !warnBorderRadiusArrayTooLarge) {
    // eslint-disable-next-line no-console
    console.warn("The `borderRadius` prop in `Textarea` component only supports up to 4 values.");
    warnBorderRadiusArrayTooLarge = true;
  }
  const minHeight = (0, _react.useRef)(_textarea.MIN_HEIGHT);
  const expandTextarea = () => {
    const textarea = internalRef.current;
    if (textarea?.scrollHeight && textarea?.scrollHeight > minHeight.current) {
      // need to reset scroll position of the nearest parent which scrolls
      let scrollElement = textarea;
      while (scrollElement && !scrollElement?.scrollTop) {
        scrollElement = scrollElement?.parentElement || null;
      }
      const scrollPosition = scrollElement?.scrollTop;
      textarea.style.height = "0px";
      // Set the height so all content is shown
      textarea.style.height = `${Math.max(textarea.scrollHeight, minHeight.current)}px`;
      if (scrollElement && scrollPosition) {
        scrollElement.scrollTop = scrollPosition;
      }
    }
  };
  const {
    labelId,
    validationId,
    fieldHelpId,
    ariaDescribedBy
  } = (0, _useInputAccessibility.default)({
    id,
    validationRedesignOptIn,
    error,
    warning,
    info,
    label,
    fieldHelp
  });
  const [characterCount, visuallyHiddenHintId] = (0, _useCharacterCount.default)(value, characterLimit);
  (0, _react.useEffect)(() => {
    if (rows) {
      minHeight.current = internalRef?.current?.scrollHeight || 0;
    }
  }, [rows]);
  (0, _react.useEffect)(() => {
    if (expandable) {
      expandTextarea();
    }
  });
  (0, _react.useEffect)(() => {
    if (expandable) {
      window.addEventListener("resize", expandTextarea);
      minHeight.current = internalRef?.current?.clientHeight || 0;
      // need to also run expandTextarea when the Sage UI font completes loading, to prevent strange scroll
      // behaviour when it only loads after the component is rendered
      document.fonts?.addEventListener("loadingdone", expandTextarea);
    }
    return () => {
      if (expandable) {
        window.removeEventListener("resize", expandTextarea);
        document.fonts?.removeEventListener("loadingdone", expandTextarea);
      }
    };
  }, [expandable]);
  const hasIconInside = !!(inputIcon || validationId && !validationOnLabel);
  const hintId = (0, _react.useRef)((0, _guid.default)());
  const inputHintId = inputHint ? hintId.current : undefined;
  const combinedAriaDescribedBy = [ariaDescribedBy, inputHintId, visuallyHiddenHintId].filter(Boolean).join(" ");
  const input = /*#__PURE__*/_react.default.createElement(_input.InputPresentation, {
    size: size,
    disabled: disabled,
    readOnly: readOnly,
    inputWidth: typeof inputWidth === "number" ? inputWidth : 100 - labelWidth,
    maxWidth: maxWidth,
    error: error,
    warning: warning,
    info: info,
    borderRadius: borderRadius,
    hideBorders: hideBorders
  }, /*#__PURE__*/_react.default.createElement(_input2.default, _extends({
    "aria-invalid": !!error,
    "aria-labelledby": ariaLabelledBy,
    ariaDescribedBy: combinedAriaDescribedBy,
    autoFocus: autoFocus,
    name: name,
    value: value,
    ref: callbackRef,
    onChange: onChange,
    disabled: disabled,
    readOnly: readOnly,
    placeholder: disabled ? "" : placeholder,
    rows: rows,
    cols: cols,
    id: id,
    as: "textarea",
    validationIconId: validationRedesignOptIn ? undefined : validationId,
    inputBorderRadius: borderRadius,
    required: required
  }, rest)), children, /*#__PURE__*/_react.default.createElement(_inputIconToggle.default, {
    disabled: disabled,
    readOnly: readOnly,
    inputIcon: inputIcon,
    size: size,
    error: error,
    warning: warning,
    info: info,
    validationIconId: validationRedesignOptIn ? undefined : validationId,
    useValidationIcon: !(validationRedesignOptIn || validationOnLabel)
  }));
  const marginProps = (0, _useFormSpacing.default)(rest);
  return /*#__PURE__*/_react.default.createElement(_tooltipProvider.TooltipProvider, {
    tooltipPosition: tooltipPosition,
    helpAriaLabel: helpAriaLabel
  }, /*#__PURE__*/_react.default.createElement(_inputBehaviour.InputBehaviour, null, /*#__PURE__*/_react.default.createElement(_textarea.default, _extends({
    labelInline: labelInline,
    "data-component": dataComponent,
    "data-role": dataRole,
    "data-element": dataElement,
    hasIcon: hasIconInside
  }, marginProps), /*#__PURE__*/_react.default.createElement(_formField.default, {
    fieldHelp: computeLabelPropValues(fieldHelp),
    fieldHelpId: fieldHelpId,
    error: error,
    warning: warning,
    info: info,
    label: label,
    labelId: labelId,
    disabled: disabled,
    id: id,
    labelInline: computeLabelPropValues(labelInline),
    labelAlign: computeLabelPropValues(labelAlign),
    labelWidth: computeLabelPropValues(labelWidth),
    labelHelp: computeLabelPropValues(labelHelp),
    labelSpacing: labelSpacing,
    isRequired: required,
    isOptional: isOptional,
    useValidationIcon: computeLabelPropValues(validationOnLabel),
    adaptiveLabelBreakpoint: adaptiveLabelBreakpoint,
    validationRedesignOptIn: validationRedesignOptIn
  }, (inputHint || labelHelp && validationRedesignOptIn) && /*#__PURE__*/_react.default.createElement(_textbox.StyledHintText, {
    id: inputHintId,
    "data-element": "input-hint"
  }, inputHint || labelHelp), validationRedesignOptIn ? /*#__PURE__*/_react.default.createElement(_box.default, {
    position: "relative"
  }, /*#__PURE__*/_react.default.createElement(_validationMessage.default, {
    error: error,
    validationId: validationId,
    warning: warning
  }), (error || warning) && /*#__PURE__*/_react.default.createElement(_textbox.ErrorBorder, {
    warning: !!(!error && warning)
  }), input) : input), characterCount)));
});
if (process.env.NODE_ENV !== "production") {
  Textarea.propTypes = {
    "about": _propTypes.default.string,
    "accept": _propTypes.default.string,
    "accessKey": _propTypes.default.string,
    "adaptiveLabelBreakpoint": _propTypes.default.number,
    "align": _propTypes.default.oneOf(["left", "right"]),
    "alt": _propTypes.default.string,
    "aria-activedescendant": _propTypes.default.string,
    "aria-atomic": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-autocomplete": _propTypes.default.oneOf(["both", "inline", "list", "none"]),
    "aria-busy": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-checked": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-colcount": _propTypes.default.number,
    "aria-colindex": _propTypes.default.number,
    "aria-colspan": _propTypes.default.number,
    "aria-controls": _propTypes.default.string,
    "aria-current": _propTypes.default.oneOfType([_propTypes.default.oneOf(["date", "false", "location", "page", "step", "time", "true"]), _propTypes.default.bool]),
    "aria-describedby": _propTypes.default.string,
    "aria-details": _propTypes.default.string,
    "aria-disabled": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-dropeffect": _propTypes.default.oneOf(["copy", "execute", "link", "move", "none", "popup"]),
    "aria-errormessage": _propTypes.default.string,
    "aria-expanded": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-flowto": _propTypes.default.string,
    "aria-grabbed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-haspopup": _propTypes.default.oneOfType([_propTypes.default.oneOf(["dialog", "false", "grid", "listbox", "menu", "tree", "true"]), _propTypes.default.bool]),
    "aria-hidden": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-invalid": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "grammar", "spelling", "true"]), _propTypes.default.bool]),
    "aria-keyshortcuts": _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "aria-labelledby": _propTypes.default.string,
    "aria-level": _propTypes.default.number,
    "aria-live": _propTypes.default.oneOf(["assertive", "off", "polite"]),
    "aria-modal": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiline": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-multiselectable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-orientation": _propTypes.default.oneOf(["horizontal", "vertical"]),
    "aria-owns": _propTypes.default.string,
    "aria-placeholder": _propTypes.default.string,
    "aria-posinset": _propTypes.default.number,
    "aria-pressed": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "mixed", "true"]), _propTypes.default.bool]),
    "aria-readonly": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-relevant": _propTypes.default.oneOf(["additions removals", "additions text", "additions", "all", "removals additions", "removals text", "removals", "text additions", "text removals", "text"]),
    "aria-required": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-roledescription": _propTypes.default.string,
    "aria-rowcount": _propTypes.default.number,
    "aria-rowindex": _propTypes.default.number,
    "aria-rowspan": _propTypes.default.number,
    "aria-selected": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "aria-setsize": _propTypes.default.number,
    "aria-sort": _propTypes.default.oneOf(["ascending", "descending", "none", "other"]),
    "aria-valuemax": _propTypes.default.number,
    "aria-valuemin": _propTypes.default.number,
    "aria-valuenow": _propTypes.default.number,
    "aria-valuetext": _propTypes.default.string,
    "ariaDescribedBy": _propTypes.default.string,
    "as": _propTypes.default.elementType,
    "autoCapitalize": _propTypes.default.string,
    "autoComplete": _propTypes.default.string,
    "autoCorrect": _propTypes.default.string,
    "autoFocus": _propTypes.default.bool,
    "autoSave": _propTypes.default.string,
    "borderRadius": _propTypes.default.any,
    "capture": _propTypes.default.oneOfType([_propTypes.default.oneOf(["environment", "user"]), _propTypes.default.bool]),
    "characterLimit": _propTypes.default.number,
    "checked": _propTypes.default.bool,
    "children": _propTypes.default.node,
    "className": _propTypes.default.string,
    "color": _propTypes.default.string,
    "cols": _propTypes.default.number,
    "content": _propTypes.default.string,
    "contentEditable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "inherit", "true"]), _propTypes.default.bool]),
    "contextMenu": _propTypes.default.string,
    "dangerouslySetInnerHTML": _propTypes.default.shape({
      "__html": _propTypes.default.oneOfType([_propTypes.default.object, _propTypes.default.string]).isRequired
    }),
    "data-component": _propTypes.default.string,
    "data-element": _propTypes.default.string,
    "data-role": _propTypes.default.string,
    "datatype": _propTypes.default.string,
    "defaultChecked": _propTypes.default.bool,
    "defaultValue": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string), _propTypes.default.number, _propTypes.default.string]),
    "dir": _propTypes.default.string,
    "disabled": _propTypes.default.bool,
    "draggable": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "enterKeyHint": _propTypes.default.oneOf(["done", "enter", "go", "next", "previous", "search", "send"]),
    "error": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "expandable": _propTypes.default.bool,
    "fieldHelp": _propTypes.default.node,
    "form": _propTypes.default.string,
    "formAction": _propTypes.default.string,
    "formEncType": _propTypes.default.string,
    "formMethod": _propTypes.default.string,
    "formNoValidate": _propTypes.default.bool,
    "formTarget": _propTypes.default.string,
    "height": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "helpAriaLabel": _propTypes.default.string,
    "hidden": _propTypes.default.bool,
    "hideBorders": _propTypes.default.bool,
    "id": _propTypes.default.string,
    "info": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "inlist": _propTypes.default.any,
    "inputBorderRadius": _propTypes.default.any,
    "inputHint": _propTypes.default.string,
    "inputIcon": _propTypes.default.oneOf(["accessibility_web", "add", "admin", "alert_on", "alert", "analysis", "app_facebook", "app_instagram", "app_tiktok", "app_twitter", "app_youtube", "apps", "arrow_bottom_right_circle", "arrow_down", "arrow_left_boxed", "arrow_left_right_small", "arrow_left_small", "arrow_left", "arrow_right_small", "arrow_right", "arrow_top_left_circle", "arrow_up", "arrow", "arrows_left_right", "attach", "bank_with_card", "bank", "basket_with_squares", "basket", "bed", "bill_paid", "bill_unpaid", "bin", "biometric", "block_arrow_right", "blocked_square", "blocked", "bold", "box_arrow_left", "box_arrow_right", "boxed_shapes", "bulk_destroy", "bullet_list_dotted", "bullet_list_numbers", "bullet_list", "business", "calendar_pay_date", "calendar_today", "calendar", "call", "camera", "car_lock", "car_money", "car_repair", "card_view", "card_wallet", "caret_down", "caret_large_down", "caret_large_left", "caret_large_right", "caret_large_up", "caret_left", "caret_right", "caret_up", "cart", "cash", "chart_bar", "chart_line", "chart_pie", "chat_notes", "chat", "check_all", "check_none", "chevron_down_thick", "chevron_down", "chevron_left_thick", "chevron_left", "chevron_right_thick", "chevron_right", "chevron_up_thick", "chevron_up", "circle_with_dots", "circles_connection", "clock", "close", "cloud_co2", "coins", "collaborate", "computer_clock", "connect_off", "connect", "construction", "contact_card", "contacts", "copy", "create", "credit_card_slash", "credit_card", "cross_circle", "cross", "csv", "dashboard", "delete", "delivery", "disconnect", "disputed", "document_right_align", "document_tick", "document_vertical_lines", "download", "draft", "drag_vertical", "drag", "drill", "dropdown", "duplicate", "edit", "edited", "ellipsis_horizontal", "ellipsis_vertical", "email_switch", "email", "entry", "envelope_dollar", "envelope_euro", "error_square", "error", "euro", "expand", "export", "factory", "favourite_lined", "favourite", "fax", "feedback", "file_excel", "file_generic", "file_image", "file_pdf", "file_word", "files_leaning", "filter_new", "filter", "fit_height", "fit_width", "flag", "folder", "form_refresh", "gift", "go", "graduation_hat", "graph", "grid", "hand_cash_coins", "hand_cash_note", "heart_pulse", "help", "hide", "home", "image", "import", "in_progress", "in_transit", "individual", "info", "intranet", "italic", "job_seeked", "key", "laptop", "leaf", "ledger_arrow_left", "ledger_arrow_right", "ledger", "lightbulb_off", "lightbulb_on", "like_no", "like", "link_cloud", "link_on", "link", "list_view", "location", "locked", "logout", "lookup", "marker", "message", "microphone", "minimise", "minus_large", "minus", "mobile", "money_bag", "none", "old_warning", "palm_tree", "pause_circle", "pause", "pdf", "people_switch", "people", "percentage_boxed", "person_info", "person_tick", "person", "petrol_pump", "phone", "piggy_bank", "pin", "plane", "play_circle", "play", "plus_large", "plus", "pound", "print", "progress", "progressed", "protect", "question_hollow", "question_mark", "question", "recruiting", "refresh_clock", "refresh", "remove", "sage_coin", "save", "scan", "search", "send", "services", "settings_old", "settings", "share", "shop", "sort_down", "sort_up", "spanner", "split_container", "split", "square_dot", "squares_nine", "stacked_boxes", "stacked_squares", "submitted", "support_online", "sync", "tag", "talk", "target_man", "target", "theatre_masks", "three_boxes", "tick_circle", "tick_thick", "tick", "true_tick", "u_turn_left", "u_turn_right", "undo", "unlocked", "upload", "uploaded", "video", "view", "volunteering", "warning", "website", "welfare"]),
    "inputMode": _propTypes.default.oneOf(["decimal", "email", "none", "numeric", "search", "tel", "text", "url"]),
    "inputWidth": _propTypes.default.number,
    "is": _propTypes.default.string,
    "isOptional": _propTypes.default.bool,
    "itemID": _propTypes.default.string,
    "itemProp": _propTypes.default.string,
    "itemRef": _propTypes.default.string,
    "itemScope": _propTypes.default.bool,
    "itemType": _propTypes.default.string,
    "label": _propTypes.default.string,
    "labelAlign": _propTypes.default.oneOf(["left", "right"]),
    "labelHelp": _propTypes.default.node,
    "labelInline": _propTypes.default.bool,
    "labelSpacing": _propTypes.default.oneOf([1, 2]),
    "labelWidth": _propTypes.default.number,
    "lang": _propTypes.default.string,
    "list": _propTypes.default.string,
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "max": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "maxLength": _propTypes.default.number,
    "maxWidth": _propTypes.default.string,
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "min": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "minLength": _propTypes.default.number,
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "multiple": _propTypes.default.bool,
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "name": _propTypes.default.string,
    "nonce": _propTypes.default.string,
    "onAbort": _propTypes.default.func,
    "onAbortCapture": _propTypes.default.func,
    "onAnimationEnd": _propTypes.default.func,
    "onAnimationEndCapture": _propTypes.default.func,
    "onAnimationIteration": _propTypes.default.func,
    "onAnimationIterationCapture": _propTypes.default.func,
    "onAnimationStart": _propTypes.default.func,
    "onAnimationStartCapture": _propTypes.default.func,
    "onAuxClick": _propTypes.default.func,
    "onAuxClickCapture": _propTypes.default.func,
    "onBeforeInput": _propTypes.default.func,
    "onBeforeInputCapture": _propTypes.default.func,
    "onBlur": _propTypes.default.func,
    "onBlurCapture": _propTypes.default.func,
    "onCanPlay": _propTypes.default.func,
    "onCanPlayCapture": _propTypes.default.func,
    "onCanPlayThrough": _propTypes.default.func,
    "onCanPlayThroughCapture": _propTypes.default.func,
    "onChange": _propTypes.default.func,
    "onChangeCapture": _propTypes.default.func,
    "onClick": _propTypes.default.func,
    "onClickCapture": _propTypes.default.func,
    "onCompositionEnd": _propTypes.default.func,
    "onCompositionEndCapture": _propTypes.default.func,
    "onCompositionStart": _propTypes.default.func,
    "onCompositionStartCapture": _propTypes.default.func,
    "onCompositionUpdate": _propTypes.default.func,
    "onCompositionUpdateCapture": _propTypes.default.func,
    "onContextMenu": _propTypes.default.func,
    "onContextMenuCapture": _propTypes.default.func,
    "onCopy": _propTypes.default.func,
    "onCopyCapture": _propTypes.default.func,
    "onCut": _propTypes.default.func,
    "onCutCapture": _propTypes.default.func,
    "onDoubleClick": _propTypes.default.func,
    "onDoubleClickCapture": _propTypes.default.func,
    "onDrag": _propTypes.default.func,
    "onDragCapture": _propTypes.default.func,
    "onDragEnd": _propTypes.default.func,
    "onDragEndCapture": _propTypes.default.func,
    "onDragEnter": _propTypes.default.func,
    "onDragEnterCapture": _propTypes.default.func,
    "onDragExit": _propTypes.default.func,
    "onDragExitCapture": _propTypes.default.func,
    "onDragLeave": _propTypes.default.func,
    "onDragLeaveCapture": _propTypes.default.func,
    "onDragOver": _propTypes.default.func,
    "onDragOverCapture": _propTypes.default.func,
    "onDragStart": _propTypes.default.func,
    "onDragStartCapture": _propTypes.default.func,
    "onDrop": _propTypes.default.func,
    "onDropCapture": _propTypes.default.func,
    "onDurationChange": _propTypes.default.func,
    "onDurationChangeCapture": _propTypes.default.func,
    "onEmptied": _propTypes.default.func,
    "onEmptiedCapture": _propTypes.default.func,
    "onEncrypted": _propTypes.default.func,
    "onEncryptedCapture": _propTypes.default.func,
    "onEnded": _propTypes.default.func,
    "onEndedCapture": _propTypes.default.func,
    "onError": _propTypes.default.func,
    "onErrorCapture": _propTypes.default.func,
    "onFocus": _propTypes.default.func,
    "onFocusCapture": _propTypes.default.func,
    "onGotPointerCapture": _propTypes.default.func,
    "onGotPointerCaptureCapture": _propTypes.default.func,
    "onInput": _propTypes.default.func,
    "onInputCapture": _propTypes.default.func,
    "onInvalid": _propTypes.default.func,
    "onInvalidCapture": _propTypes.default.func,
    "onKeyDown": _propTypes.default.func,
    "onKeyDownCapture": _propTypes.default.func,
    "onKeyPress": _propTypes.default.func,
    "onKeyPressCapture": _propTypes.default.func,
    "onKeyUp": _propTypes.default.func,
    "onKeyUpCapture": _propTypes.default.func,
    "onLoad": _propTypes.default.func,
    "onLoadCapture": _propTypes.default.func,
    "onLoadedData": _propTypes.default.func,
    "onLoadedDataCapture": _propTypes.default.func,
    "onLoadedMetadata": _propTypes.default.func,
    "onLoadedMetadataCapture": _propTypes.default.func,
    "onLoadStart": _propTypes.default.func,
    "onLoadStartCapture": _propTypes.default.func,
    "onLostPointerCapture": _propTypes.default.func,
    "onLostPointerCaptureCapture": _propTypes.default.func,
    "onMouseDown": _propTypes.default.func,
    "onMouseDownCapture": _propTypes.default.func,
    "onMouseEnter": _propTypes.default.func,
    "onMouseLeave": _propTypes.default.func,
    "onMouseMove": _propTypes.default.func,
    "onMouseMoveCapture": _propTypes.default.func,
    "onMouseOut": _propTypes.default.func,
    "onMouseOutCapture": _propTypes.default.func,
    "onMouseOver": _propTypes.default.func,
    "onMouseOverCapture": _propTypes.default.func,
    "onMouseUp": _propTypes.default.func,
    "onMouseUpCapture": _propTypes.default.func,
    "onPaste": _propTypes.default.func,
    "onPasteCapture": _propTypes.default.func,
    "onPause": _propTypes.default.func,
    "onPauseCapture": _propTypes.default.func,
    "onPlay": _propTypes.default.func,
    "onPlayCapture": _propTypes.default.func,
    "onPlaying": _propTypes.default.func,
    "onPlayingCapture": _propTypes.default.func,
    "onPointerCancel": _propTypes.default.func,
    "onPointerCancelCapture": _propTypes.default.func,
    "onPointerDown": _propTypes.default.func,
    "onPointerDownCapture": _propTypes.default.func,
    "onPointerEnter": _propTypes.default.func,
    "onPointerEnterCapture": _propTypes.default.func,
    "onPointerLeave": _propTypes.default.func,
    "onPointerLeaveCapture": _propTypes.default.func,
    "onPointerMove": _propTypes.default.func,
    "onPointerMoveCapture": _propTypes.default.func,
    "onPointerOut": _propTypes.default.func,
    "onPointerOutCapture": _propTypes.default.func,
    "onPointerOver": _propTypes.default.func,
    "onPointerOverCapture": _propTypes.default.func,
    "onPointerUp": _propTypes.default.func,
    "onPointerUpCapture": _propTypes.default.func,
    "onProgress": _propTypes.default.func,
    "onProgressCapture": _propTypes.default.func,
    "onRateChange": _propTypes.default.func,
    "onRateChangeCapture": _propTypes.default.func,
    "onReset": _propTypes.default.func,
    "onResetCapture": _propTypes.default.func,
    "onScroll": _propTypes.default.func,
    "onScrollCapture": _propTypes.default.func,
    "onSeeked": _propTypes.default.func,
    "onSeekedCapture": _propTypes.default.func,
    "onSeeking": _propTypes.default.func,
    "onSeekingCapture": _propTypes.default.func,
    "onSelect": _propTypes.default.func,
    "onSelectCapture": _propTypes.default.func,
    "onStalled": _propTypes.default.func,
    "onStalledCapture": _propTypes.default.func,
    "onSubmit": _propTypes.default.func,
    "onSubmitCapture": _propTypes.default.func,
    "onSuspend": _propTypes.default.func,
    "onSuspendCapture": _propTypes.default.func,
    "onTimeUpdate": _propTypes.default.func,
    "onTimeUpdateCapture": _propTypes.default.func,
    "onTouchCancel": _propTypes.default.func,
    "onTouchCancelCapture": _propTypes.default.func,
    "onTouchEnd": _propTypes.default.func,
    "onTouchEndCapture": _propTypes.default.func,
    "onTouchMove": _propTypes.default.func,
    "onTouchMoveCapture": _propTypes.default.func,
    "onTouchStart": _propTypes.default.func,
    "onTouchStartCapture": _propTypes.default.func,
    "onTransitionEnd": _propTypes.default.func,
    "onTransitionEndCapture": _propTypes.default.func,
    "onVolumeChange": _propTypes.default.func,
    "onVolumeChangeCapture": _propTypes.default.func,
    "onWaiting": _propTypes.default.func,
    "onWaitingCapture": _propTypes.default.func,
    "onWheel": _propTypes.default.func,
    "onWheelCapture": _propTypes.default.func,
    "pattern": _propTypes.default.string,
    "placeholder": _propTypes.default.string,
    "prefix": _propTypes.default.string,
    "property": _propTypes.default.string,
    "radioGroup": _propTypes.default.string,
    "readOnly": _propTypes.default.bool,
    "rel": _propTypes.default.string,
    "required": _propTypes.default.bool,
    "resource": _propTypes.default.string,
    "results": _propTypes.default.number,
    "rev": _propTypes.default.string,
    "role": _propTypes.default.oneOfType([_propTypes.default.oneOf(["alert", "alertdialog", "application", "article", "banner", "button", "cell", "checkbox", "columnheader", "combobox", "complementary", "contentinfo", "definition", "dialog", "directory", "document", "feed", "figure", "form", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "main", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "navigation", "none", "note", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "search", "searchbox", "separator", "slider", "spinbutton", "status", "switch", "tab", "table", "tablist", "tabpanel", "term", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"]), _propTypes.default.shape({
      "__@iterator": _propTypes.default.func.isRequired,
      "anchor": _propTypes.default.func.isRequired,
      "at": _propTypes.default.func.isRequired,
      "big": _propTypes.default.func.isRequired,
      "blink": _propTypes.default.func.isRequired,
      "bold": _propTypes.default.func.isRequired,
      "charAt": _propTypes.default.func.isRequired,
      "charCodeAt": _propTypes.default.func.isRequired,
      "codePointAt": _propTypes.default.func.isRequired,
      "concat": _propTypes.default.func.isRequired,
      "endsWith": _propTypes.default.func.isRequired,
      "fixed": _propTypes.default.func.isRequired,
      "fontcolor": _propTypes.default.func.isRequired,
      "fontsize": _propTypes.default.func.isRequired,
      "includes": _propTypes.default.func.isRequired,
      "indexOf": _propTypes.default.func.isRequired,
      "italics": _propTypes.default.func.isRequired,
      "lastIndexOf": _propTypes.default.func.isRequired,
      "length": _propTypes.default.number.isRequired,
      "link": _propTypes.default.func.isRequired,
      "localeCompare": _propTypes.default.func.isRequired,
      "match": _propTypes.default.func.isRequired,
      "matchAll": _propTypes.default.func.isRequired,
      "normalize": _propTypes.default.func.isRequired,
      "padEnd": _propTypes.default.func.isRequired,
      "padStart": _propTypes.default.func.isRequired,
      "repeat": _propTypes.default.func.isRequired,
      "replace": _propTypes.default.func.isRequired,
      "search": _propTypes.default.func.isRequired,
      "slice": _propTypes.default.func.isRequired,
      "small": _propTypes.default.func.isRequired,
      "split": _propTypes.default.func.isRequired,
      "startsWith": _propTypes.default.func.isRequired,
      "strike": _propTypes.default.func.isRequired,
      "sub": _propTypes.default.func.isRequired,
      "substr": _propTypes.default.func.isRequired,
      "substring": _propTypes.default.func.isRequired,
      "sup": _propTypes.default.func.isRequired,
      "toLocaleLowerCase": _propTypes.default.func.isRequired,
      "toLocaleUpperCase": _propTypes.default.func.isRequired,
      "toLowerCase": _propTypes.default.func.isRequired,
      "toString": _propTypes.default.func.isRequired,
      "toUpperCase": _propTypes.default.func.isRequired,
      "trim": _propTypes.default.func.isRequired,
      "trimEnd": _propTypes.default.func.isRequired,
      "trimLeft": _propTypes.default.func.isRequired,
      "trimRight": _propTypes.default.func.isRequired,
      "trimStart": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    })]),
    "rows": _propTypes.default.number,
    "security": _propTypes.default.string,
    "size": _propTypes.default.oneOf(["large", "medium", "small"]),
    "slot": _propTypes.default.string,
    "spellCheck": _propTypes.default.oneOfType([_propTypes.default.oneOf(["false", "true"]), _propTypes.default.bool]),
    "src": _propTypes.default.string,
    "step": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string]),
    "style": _propTypes.default.object,
    "suppressContentEditableWarning": _propTypes.default.bool,
    "suppressHydrationWarning": _propTypes.default.bool,
    "tabIndex": _propTypes.default.number,
    "title": _propTypes.default.string,
    "tooltipMessage": _propTypes.default.string,
    "tooltipPosition": _propTypes.default.oneOf(["bottom", "left", "right", "top"]),
    "translate": _propTypes.default.oneOf(["no", "yes"]),
    "typeof": _propTypes.default.string,
    "unselectable": _propTypes.default.oneOf(["off", "on"]),
    "validationIconId": _propTypes.default.string,
    "validationOnLabel": _propTypes.default.bool,
    "value": _propTypes.default.string,
    "vocab": _propTypes.default.string,
    "warning": _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),
    "width": _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string])
  };
}
Textarea.displayName = "Textarea";
var _default = exports.default = Textarea;