import React from "react";
import { MarginProps } from "styled-system";
import { IconType } from "../icon";
import { ValidationProps } from "../../__internal__/validations";
import { CommonInputProps } from "../../__internal__/input";
import { BorderRadiusType } from "../box/box.component";
export interface TextareaProps extends ValidationProps, MarginProps, Omit<CommonInputProps, "size"> {
    /** Prop to specify the aria-labelledby property of the component */
    "aria-labelledby"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-component"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-element"?: string;
    /** Identifier used for testing purposes, applied to the root element of the component. */
    "data-role"?: string;
    /** id of the input */
    id?: string;
    /** Breakpoint for adaptive label (inline labels change to top aligned). Enables the adaptive behaviour when set */
    adaptiveLabelBreakpoint?: number;
    /** Automatically focus the input on component mount */
    autoFocus?: boolean;
    /** Character limit of the textarea */
    characterLimit?: number;
    /** Type of the icon that will be rendered next to the input */
    children?: React.ReactNode;
    /** The visible width of the text control, in average character widths */
    cols?: number;
    /** If true, the component will be disabled */
    disabled?: boolean;
    /** Indicate that error has occurred
    Pass string to display icon, tooltip and red border
    Pass true boolean to only display red border */
    error?: boolean | string;
    /** Allows the Textareas Height to change based on user input */
    expandable?: boolean;
    /** A hint string rendered before the input but after the label. Intended to describe the purpose or content of the input. */
    inputHint?: string;
    /** Help content to be displayed under an input */
    fieldHelp?: React.ReactNode;
    /** Aria label for rendered help component */
    helpAriaLabel?: string;
    /** Indicate additional information
    Pass string to display icon, tooltip and blue border
    Pass true boolean to only display blue border */
    info?: boolean | string;
    /**
     * <a href="https://brand.sage.com/d/NdbrveWvNheA/foundations#/icons/icons" target="_blank">List of supported icons</a>
     *
     * Icon to display inside of the Textarea
     */
    inputIcon?: IconType;
    /** Width of an input in percentage. Works only when labelInline is true */
    inputWidth?: number;
    /**
     * Prop for specifying the max width of the input.
     * Leaving the `maxWidth` prop with no value will default the width to '100%'
     */
    maxWidth?: string;
    /** The content of the label for the input */
    label?: string;
    /** Inline label alignment */
    labelAlign?: "left" | "right";
    /** [Legacy] Text applied to label help tooltip. When opted into new design validations
     * it will render as a hint above the input, unless an `inputHint`
     * prop is also passed
     */
    labelHelp?: React.ReactNode;
    /** When true, label is placed in line an input */
    labelInline?: boolean;
    /** Spacing between label and a field for inline label, given number will be multiplied by base spacing unit (8) */
    labelSpacing?: 1 | 2;
    /** Width of a label in percentage. Works only when labelInline is true */
    labelWidth?: number;
    /** Name of the input */
    name?: string;
    /** Callback fired when the user types in the Textarea */
    onChange?: (ev: React.ChangeEvent<HTMLInputElement>) => void;
    /** Placeholder text for the component */
    placeholder?: string;
    /** Adds readOnly property */
    readOnly?: boolean;
    /** Flag to configure component as optional */
    isOptional?: boolean;
    /** The number of visible text lines for the control */
    rows?: number;
    /** One of type of size to apply to the textarea */
    size?: "small" | "medium" | "large";
    /** Message to be displayed in a Tooltip when the user hovers over the help icon */
    tooltipMessage?: string;
    /** Overrides the default tooltip position */
    tooltipPosition?: "top" | "bottom" | "left" | "right";
    /** When true, validation icon will be placed on label instead of being placed on the input */
    validationOnLabel?: boolean;
    /** The value of the Textbox */
    value?: string;
    /** Indicate that warning has occurred
    Pass string to display icon, tooltip and orange border
    Pass true boolean to only display orange border */
    warning?: boolean | string;
    /** Specify a custom border radius for the component. Any valid border-radius design token, or an array of border-radius design tokens. */
    borderRadius?: BorderRadiusType | BorderRadiusType[];
    /** Hides the borders for the component. Please note that validation and focus styling will still be applied */
    hideBorders?: boolean;
}
export declare const Textarea: React.ForwardRefExoticComponent<TextareaProps & React.RefAttributes<HTMLTextAreaElement>>;
export { Textarea as OriginalTextarea };
export default Textarea;
