"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledEditorWrapper = exports.StyledEditorOutline = exports.StyledEditorContainer = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _styledSystem = require("styled-system");
var _base = _interopRequireDefault(require("../../style/themes/base"));
var _browserTypeCheck = require("../../__internal__/utils/helpers/browser-type-check");
var _addFocusStyling = _interopRequireDefault(require("../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const lineHeight = 21;
const StyledEditorWrapper = exports.StyledEditorWrapper = _styledComponents.default.div`
  ${_styledSystem.margin}
`;
StyledEditorWrapper.defaultProps = {
  theme: _base.default
};
const StyledEditorContainer = exports.StyledEditorContainer = _styledComponents.default.div`
  ${({
  hasError,
  rows,
  hasPreview
}) => (0, _styledComponents.css)`
    border-radius: var(--borderRadius050);
    min-height: ${rows ? `${rows * lineHeight}` : `${hasPreview ? 125 : 220}`}px;
    position: relative;

    div.DraftEditor-root {
      min-height: inherit;
      height: 100%;
      min-width: 290px;
      margin: 4px;
    }

    div.DraftEditor-editorContainer,
    div.public-DraftEditor-content {
      min-height: inherit;
      height: 100%;
      min-width: 290px;
      background-color: var(--colorsUtilityYang100);
      line-height: ${lineHeight}px;

      ${!(0, _browserTypeCheck.isSafari)(navigator) && (0, _styledComponents.css)`
        .text-editor-block-ordered {
          position: relative;
          left: -4px;
          padding-left: 4px;
        }

        .text-editor-block-unordered {
          position: relative;
        }
      `}
    }

    div.public-DraftEditor-content {
      padding: 14px 8px;
    }

    background-color: var(--colorsUtilityYang100);
    outline: ${hasError ? "2px solid var(--colorsSemanticNegative500)" : "1px solid var(--colorsUtilityMajor200)"};
  `}
`;
const StyledEditorOutline = exports.StyledEditorOutline = _styledComponents.default.div`
  ${({
  isFocused,
  hasError,
  theme
}) => (0, _styledComponents.css)`
    border-radius: var(--borderRadius050);
    outline: none;

    ${isFocused && (0, _styledComponents.css)`
      ${!theme.focusRedesignOptOut ? (0, _addFocusStyling.default)() : `
        outline: 3px solid var(--colorsSemanticFocus500);
        outline-offset: ${hasError ? "2px" : "1px"};
      `}
    `}
  `}
`;