"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TextEditorState = exports.TextEditorContentState = exports.TextEditor = exports.EditorContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _draftJs = require("draft-js");
var _utils = require("./__internal__/utils");
var _textEditor = require("./text-editor.style");
var _editorValidationWrapper = _interopRequireDefault(require("./__internal__/editor-validation-wrapper"));
var _toolbar = _interopRequireDefault(require("./__internal__/toolbar"));
var _label = _interopRequireDefault(require("../../__internal__/label"));
var _events = _interopRequireDefault(require("../../__internal__/utils/helpers/events"));
var _guid = _interopRequireDefault(require("../../__internal__/utils/helpers/guid"));
var _labelWrapper = _interopRequireDefault(require("./__internal__/label-wrapper"));
var _types = require("./types");
var _carbonProvider = require("../carbon-provider/carbon-provider.component");
var _textbox = require("../textbox/textbox.style");
var _validationMessage = _interopRequireDefault(require("../../__internal__/validation-message"));
var _useInputAccessibility = _interopRequireDefault(require("../../hooks/__internal__/useInputAccessibility"));
var _box = _interopRequireDefault(require("../box"));
var _useCharacterCount = _interopRequireDefault(require("../../hooks/__internal__/useCharacterCount"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { _extends = Object.assign ? Object.assign.bind() : function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }
const NUMBERS = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
const INLINE_STYLES = [_types.BOLD, _types.ITALIC];
const EditorContext = exports.EditorContext = /*#__PURE__*/_react.default.createContext({});
const TextEditor = exports.TextEditor = /*#__PURE__*/_react.default.forwardRef(({
  characterLimit = 3000,
  labelText,
  onChange,
  value,
  required,
  error,
  warning,
  info,
  toolbarElements,
  rows,
  previews,
  onLinkAdded,
  inputHint,
  isOptional,
  ...rest
}, ref) => {
  const {
    validationRedesignOptIn
  } = (0, _react.useContext)(_carbonProvider.NewValidationContext);
  const [isFocused, setIsFocused] = (0, _react.useState)(false);
  const [inlines, setInlines] = (0, _react.useState)([]);
  const [activeInlines, setActiveInlines] = (0, _react.useState)({});
  const [focusToolbar, setFocusToolbar] = (0, _react.useState)(false);
  const editorRef = (0, _react.useRef)(null);
  const wrapper = (0, _react.useRef)(null);
  const editor = ref || editorRef;
  const contentLength = (0, _utils.getContent)(value).getPlainText("").length;
  const moveCursor = (0, _react.useRef)(contentLength > 0);
  const lastKeyPressed = (0, _react.useRef)();
  const inputHintId = (0, _react.useRef)(`${(0, _guid.default)()}-hint`);
  const {
    current: id
  } = (0, _react.useRef)((0, _guid.default)());
  const {
    labelId,
    validationId,
    ariaDescribedBy
  } = (0, _useInputAccessibility.default)({
    id,
    validationRedesignOptIn,
    error,
    warning,
    info,
    label: labelText
  });
  const [characterCount, visuallyHiddenHintId] = (0, _useCharacterCount.default)((0, _utils.getContent)(value).getPlainText(""), characterLimit);
  const combinedAriaDescribedBy = [ariaDescribedBy, inputHint ? inputHintId.current : undefined, visuallyHiddenHintId].filter(Boolean).join(" ");
  if (rows && (typeof rows !== "number" || rows < 2)) {
    // eslint-disable-next-line no-console
    console.warn(`Prop rows must be a number value that is 2 or greater to override the min-height of the \`${TextEditor.displayName}\``);
  }
  const keyBindingFn = ev => {
    if (_events.default.isTabKey(ev) && !_events.default.isShiftKey(ev)) {
      setFocusToolbar(true);
    }
    return (0, _draftJs.getDefaultKeyBinding)(ev);
  };
  const BLOCK_TYPES = ["unordered-list-item", "ordered-list-item"];
  const handleKeyCommand = command => {
    // bail out if the enter is pressed and limit has been reached
    if (command.includes("split-block") && contentLength === characterLimit) {
      return "handled";
    }

    // if the backspace or enter is pressed get block type and text
    if (command.includes("backspace") || command.includes("split-block")) {
      const {
        blockLength,
        blockType
      } = (0, _utils.getContentInfo)(value);

      // if a block control is active and there is no text, deactivate it and reset the block
      if (BLOCK_TYPES.includes(blockType) && !blockLength) {
        onChange((0, _utils.resetBlockType)(value, "unstyled"));
        return "handled";
      }
    }
    const style = command.toUpperCase();

    // if formatting shortcut used eg. command is "bold" or "italic"
    if (style === _types.BOLD || style === _types.ITALIC) {
      const update = _draftJs.RichUtils.handleKeyCommand(value, command);

      // istanbul ignore else
      if (update) {
        onChange(update);
        setActiveInlines({
          ...activeInlines,
          [style]: !(0, _utils.hasInlineStyle)(value, style)
        });
        return "handled";
      }
    }
    return "not-handled";
  };
  const handleBeforeInput = (str, newState) => {
    // short circuit if exceeds character limit
    if (contentLength >= characterLimit) {
      return "handled";
    }
    setActiveInlines({});

    // there is a bug in how DraftJS handles the macOS double-space-period feature, this is added to catch this and
    // prevent the editor from crashing until a fix can be added to their codebase
    if (lastKeyPressed.current === " " && !(0, _utils.isASCIIChar)(str)) {
      lastKeyPressed.current = null;
      onChange((0, _utils.replaceText)(newState, " ", newState.getCurrentInlineStyle()));
      return "handled";
    }
    if (str === " ") {
      lastKeyPressed.current = str;
      return "not-handled";
    }
    lastKeyPressed.current = null;
    // short circuit if str does not match expected chars
    if (![".", "*"].includes(str)) {
      return "not-handled";
    }
    const {
      blockType,
      blockLength,
      blockText
    } = (0, _utils.getContentInfo)(value);
    if (blockLength === 1 && NUMBERS.includes(blockText) && str === "." || blockLength === 0 && str === "*") {
      const newBlockType = (0, _utils.computeBlockType)(str, blockType);
      const hasNumberList = (0, _utils.hasBlockStyle)(value, _types.ORDERED_LIST);
      const hasBulletList = (0, _utils.hasBlockStyle)(value, _types.UNORDERED_LIST);
      if (BLOCK_TYPES.includes(newBlockType) && !hasNumberList && !hasBulletList) {
        onChange((0, _utils.resetBlockType)(value, newBlockType));
        setActiveInlines({
          BOLD: (0, _utils.hasInlineStyle)(value, _types.BOLD),
          ITALIC: (0, _utils.hasInlineStyle)(value, _types.ITALIC)
        });
        return "handled";
      }
    }
    onChange(value);
    return "not-handled";
  };
  const handlePastedText = pastedText => {
    const selectedTextLength = (0, _utils.getSelectedLength)(value);
    const newLength = contentLength + pastedText?.length - selectedTextLength;
    // if the pastedText will exceed the limit trim the excess
    if (newLength > characterLimit) {
      const newContentState = _draftJs.Modifier.insertText((0, _utils.getContent)(value), value.getSelection(), pastedText.substring(0, characterLimit - contentLength));
      const newState = _draftJs.EditorState.push(value, newContentState, "insert-fragment");
      onChange(newState);
      return "handled";
    }
    setActiveInlines({});
    return "not-handled";
  };
  const getEditorState = () => {
    let editorState = (0, _utils.getDecoratedValue)(value);

    // should the cursor position be forced to the end of the content
    if (contentLength > 0 && moveCursor.current && isFocused) {
      editorState = (0, _utils.moveSelectionToEnd)(editorState);
      moveCursor.current = false;
    }
    return editorState;
  };
  const editorState = getEditorState();
  const activeControls = {
    BOLD: activeInlines.BOLD !== undefined ? activeInlines.BOLD : (0, _utils.hasInlineStyle)(editorState, _types.BOLD),
    ITALIC: activeInlines.ITALIC !== undefined ? activeInlines.ITALIC : (0, _utils.hasInlineStyle)(editorState, _types.ITALIC),
    "unordered-list-item": (0, _utils.hasBlockStyle)(editorState, _types.UNORDERED_LIST),
    "ordered-list-item": (0, _utils.hasBlockStyle)(editorState, _types.ORDERED_LIST)
  };
  const handleEditorFocus = (0, _react.useCallback)(focusValue => {
    moveCursor.current = true;
    if (focusValue && typeof editor === "object" && editor.current !== document.activeElement) {
      editor.current?.focus();
      setFocusToolbar(false);
    }
    setIsFocused(focusValue);
  }, [editor]);
  const handleInlineStyleChange = (ev, style) => {
    ev.preventDefault();
    setActiveInlines({
      ...activeInlines,
      [style]: !(0, _utils.hasInlineStyle)(value, style)
    });
    handleEditorFocus(true);
    setInlines([...inlines, style]);
  };
  const handleBlockStyleChange = (ev, newBlockType) => {
    ev.preventDefault();
    handleEditorFocus(true);
    onChange(_draftJs.RichUtils.toggleBlockType(value, newBlockType));
    const temp = [];
    INLINE_STYLES.forEach(style => {
      if (activeInlines[style] !== undefined) {
        temp.push(style);
      }
    });
    setInlines(temp);
  };
  (0, _react.useEffect)(() => {
    // apply the inline styling, having it run in as an effect ensures that styles can be added
    // even when the editor is not focused
    INLINE_STYLES.forEach(style => {
      const preserveStyle = activeInlines[style] !== undefined && activeInlines[style] !== (0, _utils.hasInlineStyle)(value, style);
      if (preserveStyle && value.getSelection().isCollapsed() || isFocused && inlines.includes(style)) {
        onChange(_draftJs.RichUtils.toggleInlineStyle(value, style));
        setInlines(inlines.filter(inline => inline !== style));
      }
      if (preserveStyle && !value.getSelection().isCollapsed()) {
        setActiveInlines({
          ...activeInlines,
          [style]: undefined
        });
      }
    });
  }, [activeInlines, contentLength, editorState, inlines, isFocused, onChange, value]);
  const handlePreviewClose = (onClose, url) => {
    // istanbul ignore else
    if (url) onClose(url);

    // istanbul ignore else
    if (typeof editor === "object") {
      editor.current?.focus();
    }
  };
  (0, _react.useEffect)(() => {
    if (required) {
      const editableElement = wrapper.current?.querySelector("div[contenteditable='true']");
      editableElement?.setAttribute("required", "");
      editableElement?.setAttribute("aria-required", "true");
    }
  }, [required]);
  return /*#__PURE__*/_react.default.createElement(EditorContext.Provider, {
    value: {
      onLinkAdded,
      editMode: true
    }
  }, /*#__PURE__*/_react.default.createElement(_textEditor.StyledEditorWrapper, _extends({
    ref: wrapper
  }, rest), /*#__PURE__*/_react.default.createElement(_labelWrapper.default, {
    onClick: () => handleEditorFocus(true)
  }, /*#__PURE__*/_react.default.createElement(_label.default, {
    labelId: labelId,
    isRequired: required,
    optional: isOptional
  }, labelText)), inputHint && /*#__PURE__*/_react.default.createElement(_textbox.StyledHintText, {
    id: inputHintId.current
  }, inputHint), /*#__PURE__*/_react.default.createElement(_box.default, {
    position: "relative"
  }, validationRedesignOptIn && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_validationMessage.default, {
    error: error,
    validationId: validationId,
    warning: warning
  }), (error || warning) && /*#__PURE__*/_react.default.createElement(_textbox.ErrorBorder, {
    warning: !!(!error && warning)
  })), /*#__PURE__*/_react.default.createElement(_textEditor.StyledEditorOutline, {
    isFocused: isFocused,
    hasError: !!error
  }, /*#__PURE__*/_react.default.createElement(_textEditor.StyledEditorContainer, {
    "data-component": "text-editor-container",
    hasError: !!error,
    rows: rows,
    hasPreview: !!_react.default.Children.count(previews)
  }, !validationRedesignOptIn && (error || warning || info) && /*#__PURE__*/_react.default.createElement(_editorValidationWrapper.default, {
    error: error,
    warning: warning,
    info: info
  }), /*#__PURE__*/_react.default.createElement(_draftJs.Editor, {
    ref: editor,
    onFocus: () => handleEditorFocus(true),
    onBlur: () => handleEditorFocus(false),
    editorState: editorState,
    onChange: onChange,
    handleBeforeInput: handleBeforeInput,
    handlePastedText: handlePastedText,
    handleKeyCommand: handleKeyCommand,
    ariaLabelledBy: labelId,
    ariaDescribedBy: combinedAriaDescribedBy,
    blockStyleFn: _utils.blockStyleFn,
    keyBindingFn: keyBindingFn,
    tabIndex: 0
  }), _react.default.Children.map(previews, preview => {
    if ( /*#__PURE__*/_react.default.isValidElement(preview)) {
      const {
        onClose
      } = preview?.props;
      return /*#__PURE__*/_react.default.cloneElement(preview, {
        as: "div",
        onClose: onClose ? url => handlePreviewClose(onClose, url) : undefined
      });
    }
    return null;
  }), /*#__PURE__*/_react.default.createElement(_toolbar.default, {
    setBlockStyle: (ev, newBlockType) => handleBlockStyleChange(ev, newBlockType),
    setInlineStyle: (ev, inlineStyle) => handleInlineStyleChange(ev, inlineStyle),
    activeControls: activeControls,
    canFocus: focusToolbar,
    toolbarElements: toolbarElements
  }))), characterCount)));
});
if (process.env.NODE_ENV !== "production") {
  TextEditor.propTypes = {
    "characterLimit": _propTypes.default.number,
    "error": _propTypes.default.string,
    "info": _propTypes.default.string,
    "inputHint": _propTypes.default.string,
    "isOptional": _propTypes.default.bool,
    "labelText": _propTypes.default.string.isRequired,
    "m": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "margin": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginBottom": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginLeft": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginRight": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginTop": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginX": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "marginY": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mb": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "ml": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mr": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mt": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "mx": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "my": _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.oneOfType([_propTypes.default.oneOf([null]), _propTypes.default.number, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string])), _propTypes.default.number, _propTypes.default.object, _propTypes.default.shape({
      "__@toStringTag": _propTypes.default.string.isRequired,
      "description": _propTypes.default.string,
      "toString": _propTypes.default.func.isRequired,
      "valueOf": _propTypes.default.func.isRequired
    }), _propTypes.default.string]),
    "onChange": _propTypes.default.func.isRequired,
    "onLinkAdded": _propTypes.default.func,
    "previews": _propTypes.default.node,
    "required": _propTypes.default.bool,
    "rows": _propTypes.default.number,
    "toolbarElements": _propTypes.default.node,
    "value": _propTypes.default.object.isRequired,
    "warning": _propTypes.default.string
  };
}
const TextEditorState = exports.TextEditorState = _draftJs.EditorState;
const TextEditorContentState = exports.TextEditorContentState = _draftJs.ContentState;
var _default = exports.default = TextEditor;