import React from "react";
import { MarginProps } from "styled-system";
import { ContentState, EditorState, Editor } from "draft-js";
export declare const EditorContext: React.Context<{
    onLinkAdded?: ((url: string) => void) | undefined;
    editMode?: boolean | undefined;
}>;
export interface TextEditorProps extends MarginProps {
    /** The maximum characters that the input will accept */
    characterLimit?: number;
    /** The text for the editor's label */
    labelText: string;
    /** onChange callback to control value updates */
    onChange: (event: EditorState) => void;
    /** Additional elements to be rendered in the Editor Toolbar, e.g. Save and Cancel Button */
    toolbarElements?: React.ReactNode;
    /** The value of the input, this is an EditorState immutable object */
    value: EditorState;
    /** Flag to configure component as mandatory. */
    required?: boolean;
    /** Flag to configure component as optional. */
    isOptional?: boolean;
    /** Message to be displayed when there is an error */
    error?: string;
    /** Message to be displayed when there is a warning */
    warning?: string;
    /** Message to be displayed when there is an info */
    info?: string;
    /** Number greater than 2 multiplied by line-height (21px) to override the default min-height of the editor */
    rows?: number;
    /** The previews to display of any links added to the Editor */
    previews?: React.ReactNode;
    /** Callback to report a url when a link is added */
    onLinkAdded?: (url: string) => void;
    /** Hint text to be rendered when validationRedesignOptIn flag is set */
    inputHint?: string;
}
export declare const TextEditor: React.ForwardRefExoticComponent<TextEditorProps & React.RefAttributes<Editor>>;
export declare const TextEditorState: typeof EditorState;
export declare const TextEditorContentState: typeof ContentState;
export default TextEditor;
