"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _toolbar = require("./toolbar.style");
var _toolbarButton = _interopRequireDefault(require("./toolbar-button"));
var _events = _interopRequireDefault(require("../../../../__internal__/utils/helpers/events"));
var _icon = _interopRequireDefault(require("../../../icon"));
var _tooltip = _interopRequireDefault(require("../../../tooltip"));
var _useLocale = _interopRequireDefault(require("../../../../hooks/__internal__/useLocale"));
var _types = require("../../types");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Toolbar = ({
  activeControls,
  canFocus,
  toolbarElements,
  setBlockStyle,
  setInlineStyle
}) => {
  const {
    textEditor
  } = (0, _useLocale.default)();
  const {
    tooltipMessages,
    ariaLabels
  } = textEditor;
  const controlRefs = (0, _react.useRef)([/*#__PURE__*/_react.default.createRef(), /*#__PURE__*/_react.default.createRef(), /*#__PURE__*/_react.default.createRef(), /*#__PURE__*/_react.default.createRef()]);
  const [focusIndex, setFocusIndex] = (0, _react.useState)(null);
  const [tabbable, setTabbable] = (0, _react.useState)(true);
  const [activeTooltip, setActiveTooltip] = (0, _react.useState)("");
  const handleInlineStyleChange = (0, _react.useCallback)((ev, inlineType) => {
    setInlineStyle(ev, inlineType);
  }, [setInlineStyle]);
  const handleBlockType = (0, _react.useCallback)((ev, blockType) => {
    setBlockStyle(ev, blockType);
  }, [setBlockStyle]);
  const handleKeyDown = (0, _react.useCallback)((ev, type) => {
    if (_events.default.isTabKey(ev)) {
      setFocusIndex(null);
    } else if (_events.default.isSpaceKey(ev) || _events.default.isEnterKey(ev)) {
      if (type === _types.BOLD || type === _types.ITALIC) {
        handleInlineStyleChange(ev, type);
      } else {
        handleBlockType(ev, type);
      }
      setFocusIndex(0);
      setTabbable(true);
    } else if (_events.default.isLeftKey(ev)) {
      if (focusIndex === null || focusIndex === 0) {
        controlRefs.current[3].current?.focus();
        setFocusIndex(3);
      } else {
        controlRefs.current[focusIndex - 1].current?.focus();
        setFocusIndex(focusIndex - 1);
      }
      setTabbable(false);
    } else if (_events.default.isRightKey(ev)) {
      if (focusIndex === 3) {
        controlRefs.current[0].current?.focus();
        setFocusIndex(0);
      } else {
        const currentIndex = focusIndex === null ? 0 : focusIndex;
        controlRefs.current[currentIndex + 1].current?.focus();
        setFocusIndex(currentIndex + 1);
      }
      setTabbable(false);
    }
  }, [focusIndex, handleBlockType, handleInlineStyleChange]);
  (0, _react.useEffect)(() => {
    if (focusIndex === null) {
      setTabbable(true);
    }
  }, [focusIndex]);
  (0, _react.useEffect)(() => {
    if (!canFocus) {
      setFocusIndex(null);
    }
  }, [canFocus]);
  const isTabbable = index => {
    if (!controlRefs.current[index] || !controlRefs.current[index].current) {
      return false;
    }
    return controlRefs.current[index].current === document.activeElement;
  };
  return /*#__PURE__*/_react.default.createElement(_toolbar.StyledToolbar, {
    "data-component": "text-editor-toolbar"
  }, /*#__PURE__*/_react.default.createElement(_toolbar.StyledEditorStyleControls, null, /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    isVisible: activeTooltip === "Bold",
    message: tooltipMessages.bold(),
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_toolbarButton.default, {
    ariaLabel: ariaLabels.bold(),
    onKeyDown: ev => handleKeyDown(ev, _types.BOLD),
    onMouseDown: ev => handleInlineStyleChange(ev, _types.BOLD),
    activated: activeControls.BOLD,
    ref: controlRefs.current[0],
    tabbable: tabbable,
    onMouseOver: () => setActiveTooltip("Bold"),
    onMouseLeave: () => setActiveTooltip(""),
    onFocus: () => setActiveTooltip("Bold"),
    onBlur: () => setActiveTooltip("")
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    color: activeControls[_types.BOLD] ? "var(--colorsActionMinorYang100)" : undefined,
    type: "bold"
  }))), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    isVisible: activeTooltip === "Italic",
    message: tooltipMessages.italic(),
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_toolbarButton.default, {
    ariaLabel: ariaLabels.italic(),
    onKeyDown: ev => handleKeyDown(ev, _types.ITALIC),
    onMouseDown: ev => handleInlineStyleChange(ev, _types.ITALIC),
    activated: activeControls.ITALIC,
    ref: controlRefs.current[1],
    tabbable: isTabbable(1),
    onMouseOver: () => setActiveTooltip("Italic"),
    onMouseLeave: () => setActiveTooltip(""),
    onFocus: () => setActiveTooltip("Italic"),
    onBlur: () => setActiveTooltip("")
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    color: activeControls[_types.ITALIC] ? "var(--colorsActionMinorYang100)" : undefined,
    type: "italic"
  }))), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    isVisible: activeTooltip === "Bulleted List",
    message: tooltipMessages.bulletList(),
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_toolbarButton.default, {
    ariaLabel: ariaLabels.bulletList(),
    onKeyDown: ev => handleKeyDown(ev, _types.UNORDERED_LIST),
    onMouseDown: ev => handleBlockType(ev, _types.UNORDERED_LIST),
    activated: activeControls[_types.UNORDERED_LIST],
    ref: controlRefs.current[2],
    tabbable: isTabbable(2),
    onMouseOver: () => setActiveTooltip("Bulleted List"),
    onMouseLeave: () => setActiveTooltip(""),
    onFocus: () => setActiveTooltip("Bulleted List"),
    onBlur: () => setActiveTooltip("")
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    color: activeControls[_types.UNORDERED_LIST] ? "var(--colorsActionMinorYang100)" : undefined,
    type: "bullet_list_dotted"
  }))), /*#__PURE__*/_react.default.createElement(_tooltip.default, {
    isVisible: activeTooltip === "Numbered List",
    message: tooltipMessages.numberList(),
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_toolbarButton.default, {
    ariaLabel: ariaLabels.numberList(),
    onKeyDown: ev => handleKeyDown(ev, _types.ORDERED_LIST),
    onMouseDown: ev => handleBlockType(ev, _types.ORDERED_LIST),
    activated: activeControls[_types.ORDERED_LIST],
    ref: controlRefs.current[3],
    tabbable: isTabbable(3),
    onMouseOver: () => setActiveTooltip("Numbered List"),
    onMouseLeave: () => setActiveTooltip(""),
    onFocus: () => setActiveTooltip("Numbered List"),
    onBlur: () => setActiveTooltip("")
  }, /*#__PURE__*/_react.default.createElement(_icon.default, {
    color: activeControls[_types.ORDERED_LIST] ? "var(--colorsActionMinorYang100)" : undefined,
    type: "bullet_list_numbers"
  })))), toolbarElements && /*#__PURE__*/_react.default.createElement(_toolbar.StyledEditorActionControls, null, toolbarElements));
};
var _default = exports.default = Toolbar;