"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _themes = require("../../../../../style/themes");
var _addFocusStyling = _interopRequireDefault(require("../../../../../style/utils/add-focus-styling"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StyledToolbarButton = _styledComponents.default.button.attrs({
  type: "button"
})`
  display: inline-flex;
  justify-content: center;
  align-items: center;
  padding: 6px;
  background-color: inherit;
  border-radius: var(--borderRadius100);
  border: none;
  cursor: pointer;

  ${({
  isActive,
  theme
}) => (0, _styledComponents.css)`
    :focus,
    :active {
      z-index: 1;
      position: relative;

      ${theme.focusRedesignOptOut && /* istanbul ignore next */
(0, _styledComponents.css)`
        outline: 2px solid var(--colorsSemanticFocus500);
        outline-offset: -2px;
      `}

      ${!theme.focusRedesignOptOut && (0, _styledComponents.css)`
        ${(0, _addFocusStyling.default)()}
      `}
    }

    :hover {
      background-color: ${!isActive && "var(--colorsActionMinor200)"};
    }

    ${isActive && (0, _styledComponents.css)`
      background-color: var(--colorsActionMinor600);
    `}
  `}
`;
StyledToolbarButton.defaultProps = {
  theme: _themes.baseTheme
};
var _default = exports.default = StyledToolbarButton;